/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithm.simulations.MultiPebble;
import owl.automaton.algorithm.simulations.Pebble;
import owl.automaton.algorithm.simulations.SimulationStates;
import owl.automaton.algorithm.simulations.SimulationType;
import owl.automaton.edge.Edge;
import owl.collections.BitSet2;
import owl.collections.Pair;

public class ForwardDelayedSimulation<S>
implements SimulationType<S, SimulationStates.MultipebbleSimulationState<S>> {
    final Automaton<S, ? extends BuchiAcceptance> leftAutomaton;
    final Automaton<S, ? extends BuchiAcceptance> rightAutomaton;
    final S leftState;
    final S rightState;
    final SimulationStates.MultipebbleSimulationState<S> initialState;
    final SimulationStates.MultipebbleSimulationState<S> sinkState;
    final int pebbleCount;
    final Set<Pair<S, S>> knownPairs;

    public ForwardDelayedSimulation(Automaton<S, ? extends BuchiAcceptance> leftAutomaton, Automaton<S, ? extends BuchiAcceptance> rightAutomaton, S left, S right, int pebbleCount, Set<Pair<S, S>> known) {
        this.leftAutomaton = leftAutomaton;
        this.rightAutomaton = rightAutomaton;
        this.leftState = left;
        this.rightState = right;
        this.pebbleCount = pebbleCount;
        this.knownPairs = known;
        this.initialState = SimulationStates.MultipebbleSimulationState.of(Pebble.of(left, false), MultiPebble.of(right, false, pebbleCount));
        this.sinkState = SimulationStates.MultipebbleSimulationState.of(Pebble.of(left, true), MultiPebble.of(List.of(), pebbleCount));
    }

    @Override
    public Set<Edge<SimulationStates.MultipebbleSimulationState<S>>> edges(SimulationStates.MultipebbleSimulationState<S> state) {
        if (state.equals(this.sinkState)) {
            return Set.of(Edge.of(this.sinkState, 1));
        }
        HashSet out = new HashSet();
        if (state.owner().isOdd()) {
            int edgeParity;
            int n = edgeParity = state.odd().flag() ? 1 : 2;
            if (1 == state.even().count() && this.knownPairs.contains(Pair.of(state.odd().state(), state.even().onlyState())) && (!state.odd().flag() || state.even().flag())) {
                return Set.of(Edge.of(state, 2));
            }
            this.leftAutomaton.edgeMap(state.odd().state()).forEach((edge, valSet) -> valSet.iterator(this.leftAutomaton.atomicPropositions().size()).forEachRemaining(val -> {
                boolean isAccepting = this.leftAutomaton.acceptance().isAcceptingEdge((Edge<?>)edge);
                SimulationStates.MultipebbleSimulationState target = SimulationStates.MultipebbleSimulationState.of(Pebble.of(edge.successor(), state.odd().flag() || isAccepting), isAccepting ? state.even().setFlag(false) : state.even(), val);
                out.add(Edge.of(target, edgeParity));
            }));
        } else {
            Set<MultiPebble<S>> possible = state.even().successors(this.rightAutomaton, BitSet2.fromInt(state.valuation()));
            if (possible.isEmpty()) {
                return Set.of(Edge.of(this.sinkState, 1));
            }
            possible.forEach(p -> {
                SimulationStates.MultipebbleSimulationState target = SimulationStates.MultipebbleSimulationState.of(p.flag() ? state.odd().withFlag(false) : state.odd(), p);
                out.add(Edge.of(target, 0));
            });
        }
        return out;
    }

    @Override
    public ParityAcceptance acceptance() {
        return new ParityAcceptance(3, ParityAcceptance.Parity.MAX_EVEN);
    }

    @Override
    public Set<SimulationStates.MultipebbleSimulationState<S>> initialStates() {
        return Set.of(this.initialState);
    }
}

