/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import com.google.auto.value.AutoValue;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.algorithm.simulations.AutoValue_Transition;
import owl.automaton.edge.Edge;
import owl.collections.BitSet2;

@AutoValue
public abstract class Transition<S> {
    abstract int valuation();

    abstract S target();

    abstract boolean flag();

    static <S> Transition<S> of(int valuation, S target, boolean flag) {
        return new AutoValue_Transition<S>(valuation, target, flag);
    }

    static <S> Transition<S> of(BitSet valuation, S target, boolean flag) {
        return Transition.of(BitSet2.toInt(valuation), target, flag);
    }

    static <S> Set<List<Transition<S>>> universe(S state, Automaton<S, ? extends BuchiAcceptance> aut, int k) {
        HashSet out2 = new HashSet();
        aut.edgeMap(state).forEach((edge1, valSet1) -> valSet1.iterator(aut.atomicPropositions().size()).forEachRemaining(val1 -> out2.add(Transition.of(val1, edge1.successor(), ((BuchiAcceptance)aut.acceptance()).isAcceptingEdge((Edge<?>)edge1)))));
        Set<List<Transition<S>>> out = out2.stream().map(List::of).collect(Collectors.toSet());
        for (int i = 1; i < k; ++i) {
            HashSet toAdd = new HashSet();
            out.forEach(t -> {
                Transition last = (Transition)t.get(t.size() - 1);
                HashSet out1 = new HashSet();
                aut.edgeMap(last.target()).forEach((edge, valSet) -> valSet.iterator(aut.atomicPropositions().size()).forEachRemaining(val -> out1.add(Transition.of(val, edge.successor(), ((BuchiAcceptance)aut.acceptance()).isAcceptingEdge((Edge<?>)edge)))));
                out1.forEach(tt -> {
                    ArrayList<Transition> concat = new ArrayList<Transition>(t.size() + 1);
                    concat.addAll((Collection<Transition>)t);
                    concat.add((Transition)tt);
                    toAdd.add(List.copyOf(concat));
                });
            });
            out.addAll(toAdd);
        }
        return out;
    }

    private static <S> boolean directMatching(List<Transition<S>> original, List<Transition<S>> candidate) {
        return Streams.zip(original.stream(), candidate.stream(), (t1, t2) -> (!t1.flag() || t2.flag()) && t1.valuation() == t2.valuation()).allMatch(b -> b);
    }

    static <S> Set<List<Transition<S>>> directMatching(S state, Automaton<S, ? extends BuchiAcceptance> aut, List<Transition<S>> moves) {
        Set<List<Transition<S>>> possible = Transition.universe(state, aut, moves.size());
        return possible.stream().filter(p -> Transition.directMatching(moves, p)).collect(Collectors.toSet());
    }

    public static <S> S end(List<Transition<S>> moves) {
        return Transition.at(moves, moves.size());
    }

    public static <S> S at(List<Transition<S>> moves, int pos) {
        return moves.get(pos - 1).target();
    }

    public String toString() {
        return "-" + (this.flag() ? ">>" : ">") + this.target();
    }

    public boolean isValid(S base, Automaton<S, BuchiAcceptance> aut) {
        return aut.successors(base, BitSet2.fromInt(this.valuation())).contains(this.target()) && aut.edges(base, BitSet2.fromInt(this.valuation())).stream().anyMatch(e -> ((BuchiAcceptance)aut.acceptance()).isAcceptingEdge((Edge<?>)e)) == this.flag();
    }
}

