/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.minimization;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.EmptyAutomaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.algorithm.LanguageContainment;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.automaton.hoa.HoaWriter;
import owl.bdd.MtBdd;
import owl.collections.Collections3;

public final class GfgCoBuchiMinimization {
    private GfgCoBuchiMinimization() {
    }

    public static <S> Automaton<Set<S>, CoBuchiAcceptance> minimize(Automaton<S, ? extends CoBuchiAcceptance> dcw) {
        Preconditions.checkArgument((boolean)dcw.is(Automaton.Property.DETERMINISTIC));
        MutableAutomaton<S, CoBuchiAcceptance> dcwCopy = MutableAutomatonUtil.asMutable(dcw);
        List<Set<S>> safeComponents = GfgCoBuchiMinimization.safeComponents(dcwCopy);
        if (dcwCopy.initialStates().isEmpty()) {
            return EmptyAutomaton.of(dcw.atomicPropositions(), CoBuchiAcceptance.INSTANCE);
        }
        GfgCoBuchiMinimization.normalize(dcwCopy, safeComponents);
        assert (LanguageContainment.equalsCoBuchi(dcw, dcwCopy));
        HashMapAutomaton<S, CoBuchiAcceptance> safeCentralized = HashMapAutomaton.copyOf(GfgCoBuchiMinimization.safeCentralize(dcwCopy, safeComponents));
        assert (LanguageContainment.equalsCoBuchi(dcwCopy, safeCentralized));
        HashMapAutomaton<Set<S>, CoBuchiAcceptance> safeMinimized = HashMapAutomaton.copyOf(GfgCoBuchiMinimization.safeMinimize(safeCentralized));
        assert (LanguageContainment.equalsCoBuchi(safeCentralized, safeMinimized)) : "before: " + HoaWriter.toString(safeCentralized) + "\nafter: " + HoaWriter.toString(safeMinimized);
        return safeMinimized;
    }

    private static <S> List<Set<S>> safeComponents(Automaton<S, ? extends CoBuchiAcceptance> ncw) {
        return SccDecomposition.of(ncw.states(), state -> ncw.edges(state).stream().filter(edge -> !edge.colours().contains(0)).map(Edge::successor).collect(Collectors.toSet())).sccs();
    }

    private static <S> void normalize(MutableAutomaton<S, ? extends CoBuchiAcceptance> ncw, List<Set<S>> safeComponents) {
        ncw.updateEdges((state, edge) -> {
            if (GfgCoBuchiMinimization.componentId(state, safeComponents) == GfgCoBuchiMinimization.componentId(edge.successor(), safeComponents)) {
                return edge;
            }
            return edge.withAcceptance(0);
        });
        ncw.trim();
    }

    private static <S> boolean languageEquivalent(Automaton<S, ? extends CoBuchiAcceptance> ncw, S q, S p) {
        return LanguageContainment.equalsCoBuchi(Views.replaceInitialStates(ncw, Set.of(q)), Views.replaceInitialStates(ncw, Set.of(p)));
    }

    private static <S> Automaton<S, AllAcceptance> safeView(final Automaton<S, ? extends CoBuchiAcceptance> ncw, S q) {
        return new AbstractMemoizingAutomaton.EdgeTreeImplementation<S, AllAcceptance>(ncw.atomicPropositions(), ncw.factory(), Set.of(q), AllAcceptance.INSTANCE){

            @Override
            public MtBdd<Edge<S>> edgeTreeImpl(S state) {
                return ncw.edgeTree(state).map(edges -> {
                    HashSet<Edge> edgesCopy = new HashSet<Edge>((Collection<Edge>)edges);
                    edgesCopy.removeIf(sEdge -> !sEdge.colours().isEmpty());
                    return edgesCopy;
                });
            }
        };
    }

    private static <S> boolean subsafeEquivalent(Automaton<S, ? extends CoBuchiAcceptance> ncw, S q, S p) {
        return GfgCoBuchiMinimization.languageEquivalent(ncw, q, p) && LanguageContainment.containsAll(GfgCoBuchiMinimization.safeView(ncw, q), GfgCoBuchiMinimization.safeView(ncw, p));
    }

    private static <S> boolean stronglyEquivalent(Automaton<S, ? extends CoBuchiAcceptance> ncw, S q, S p) {
        return GfgCoBuchiMinimization.languageEquivalent(ncw, q, p) && LanguageContainment.equalsAll(GfgCoBuchiMinimization.safeView(ncw, q), GfgCoBuchiMinimization.safeView(ncw, p));
    }

    private static <S> Automaton<S, CoBuchiAcceptance> safeCentralize(final Automaton<S, ? extends CoBuchiAcceptance> ncw, List<Set<S>> safeComponents) {
        final List<Set> frontier = Collections3.maximalElements(safeComponents, (component1, component2) -> {
            Object representative1 = component1.iterator().next();
            for (Object representative2 : component2) {
                if (!GfgCoBuchiMinimization.subsafeEquivalent(ncw, representative1, representative2)) continue;
                return true;
            }
            return false;
        });
        Object initialState = null;
        for (Set safeComponent : frontier) {
            if (!safeComponent.contains(ncw.initialState())) continue;
            initialState = ncw.initialState();
            break;
        }
        if (initialState == null) {
            block1: for (Set safeComponent : frontier) {
                for (Object state : safeComponent) {
                    if (!GfgCoBuchiMinimization.subsafeEquivalent(ncw, ncw.initialState(), state)) continue;
                    initialState = state;
                    break block1;
                }
            }
        }
        assert (initialState != null);
        return new AbstractMemoizingAutomaton.EdgesImplementation<S, CoBuchiAcceptance>(ncw.atomicPropositions(), ncw.factory(), Set.of(initialState), CoBuchiAcceptance.INSTANCE){

            @Override
            protected Set<Edge<S>> edgesImpl(S state, BitSet valuation) {
                HashSet acceptingEdges = new HashSet();
                HashSet rejectingSuccessors = new HashSet();
                ncw.edges(state, valuation).forEach(edge -> {
                    if (edge.colours().contains(0)) {
                        rejectingSuccessors.add(edge.successor());
                    } else {
                        assert (edge.colours().isEmpty());
                        acceptingEdges.add((Edge)edge);
                    }
                });
                if (acceptingEdges.isEmpty()) {
                    HashSet rejectingEdges = new HashSet();
                    for (Object rejectingSuccessor : rejectingSuccessors) {
                        for (Set safeComponent : frontier) {
                            for (Object safeSuccessor : safeComponent) {
                                if (!GfgCoBuchiMinimization.subsafeEquivalent(ncw, rejectingSuccessor, safeSuccessor)) continue;
                                rejectingEdges.add(Edge.of(safeSuccessor, 0));
                            }
                        }
                    }
                    return rejectingEdges;
                }
                return acceptingEdges;
            }
        };
    }

    private static <S> Automaton<Set<S>, CoBuchiAcceptance> safeMinimize(final Automaton<S, ? extends CoBuchiAcceptance> ncw) {
        ArrayList<HashSet<S>> equivalenceClasses = new ArrayList<HashSet<S>>();
        block0: for (S state : ncw.states()) {
            for (Set set : equivalenceClasses) {
                Object representative = set.iterator().next();
                if (!GfgCoBuchiMinimization.stronglyEquivalent(ncw, state, representative)) continue;
                set.add(state);
                continue block0;
            }
            equivalenceClasses.add(new HashSet<S>(Set.of(state)));
        }
        final List immutableEquivalenceClass = equivalenceClasses.stream().map(Set::copyOf).collect(Collectors.toList());
        Set initialStates = immutableEquivalenceClass.stream().filter(x -> !Collections.disjoint(x, ncw.initialStates())).collect(Collectors.toUnmodifiableSet());
        return new AbstractMemoizingAutomaton.EdgesImplementation<Set<S>, CoBuchiAcceptance>(ncw.atomicPropositions(), ncw.factory(), initialStates, CoBuchiAcceptance.INSTANCE){

            @Override
            protected Set<Edge<Set<S>>> edgesImpl(Set<S> state, BitSet valuation) {
                HashSet edges = new HashSet();
                for (Object representative : state) {
                    EdgeType type = EdgeType.UNKNOWN;
                    for (Edge edge : ncw.edges(representative, valuation)) {
                        Object successorRepresentative = edge.successor();
                        if (edge.colours().contains(0)) {
                            assert (type == EdgeType.UNKNOWN || type == EdgeType.REJECTING);
                            type = EdgeType.REJECTING;
                        } else {
                            assert (type == EdgeType.UNKNOWN || type == EdgeType.ACCEPTING);
                            type = EdgeType.ACCEPTING;
                        }
                        Set successor = GfgCoBuchiMinimization.findEquivalenceClass(immutableEquivalenceClass, successorRepresentative);
                        edges.add(type == EdgeType.REJECTING ? Edge.of(successor, 0) : Edge.of(successor));
                    }
                }
                return edges;
            }
        };
    }

    private static <S> int componentId(S state, List<Set<S>> components) {
        int i = 0;
        for (Set<S> component : components) {
            if (component.contains(state)) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException("Internal error.");
    }

    private static <S> Set<S> findEquivalenceClass(List<Set<S>> equivalenceClasses, S representative) {
        for (Set<S> equivalenceClass : equivalenceClasses) {
            if (!equivalenceClass.contains(representative)) continue;
            return equivalenceClass;
        }
        throw new IllegalStateException("Internal error.");
    }

    static enum EdgeType {
        ACCEPTING,
        REJECTING,
        UNKNOWN;

    }
}

