/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.symbolic;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import owl.automaton.symbolic.SymbolicAutomaton;
import owl.collections.ImmutableBitSet;

public class ManualVariableAllocation
implements SymbolicAutomaton.VariableAllocation {
    private final List<SymbolicAutomaton.VariableType> variables;

    @VisibleForTesting
    ManualVariableAllocation(SymbolicAutomaton.VariableType ... variables) {
        this(List.of(variables));
    }

    private ManualVariableAllocation(List<SymbolicAutomaton.VariableType> variables) {
        this.variables = List.copyOf(variables);
    }

    @Override
    public ImmutableBitSet variables(SymbolicAutomaton.VariableType ... types) {
        BitSet bitset = new BitSet();
        EnumSet<SymbolicAutomaton.VariableType> typeSet = EnumSet.copyOf(Arrays.asList(types));
        for (int i = 0; i < this.variables.size(); ++i) {
            if (!typeSet.contains((Object)this.variables.get(i))) continue;
            bitset.set(i);
        }
        return ImmutableBitSet.copyOf(bitset);
    }

    @Override
    public int numberOfVariables() {
        return this.variables.size();
    }

    @Override
    public SymbolicAutomaton.VariableType typeOf(int variable) {
        return this.variables.get(variable);
    }

    @Override
    public List<String> variableNames() {
        ArrayList<String> result = new ArrayList<String>(this.numberOfVariables());
        int state = 0;
        int colour = 0;
        int ap = 0;
        int suc = 0;
        block6: for (int i = 0; i < this.numberOfVariables(); ++i) {
            switch (this.typeOf(i)) {
                case STATE: {
                    result.add(String.format("s_%d", state++));
                    continue block6;
                }
                case COLOUR: {
                    result.add(String.format("c_%d", colour++));
                    continue block6;
                }
                case ATOMIC_PROPOSITION: {
                    result.add(String.format("ap_%d", ap++));
                    continue block6;
                }
                case SUCCESSOR_STATE: {
                    result.add(String.format("x_%d", suc++));
                    continue block6;
                }
                default: {
                    throw new AssertionError((Object)("Encountered unknown type " + this.typeOf(i)));
                }
            }
        }
        return result;
    }

    @Override
    public int localToGlobal(int variable, SymbolicAutomaton.VariableType type) {
        int local = -1;
        for (int global = 0; global < this.numberOfVariables(); ++global) {
            if (this.typeOf(global) == type) {
                ++local;
            }
            if (local != variable) continue;
            return global;
        }
        throw new IllegalArgumentException(variable + " is not a variable of type " + type);
    }

    @Override
    public int globalToLocal(int variable, SymbolicAutomaton.VariableType type) {
        int j = 0;
        for (int i = 0; i < variable; ++i) {
            if (this.typeOf(i) != type) continue;
            ++j;
        }
        return j;
    }
}

