/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import java.util.Arrays;
import java.util.Objects;
import org.graalvm.nativeimage.c.type.CDoublePointer;
import org.graalvm.word.WordFactory;
import owl.cinterface.CDoubleVector;
import owl.cinterface.UnmanagedMemory;
import owl.util.ArraysSupport;

public final class CDoubleVectorBuilder {
    private CDoublePointer elements;
    private int capacity;
    private int size = 0;

    public CDoubleVectorBuilder() {
        this(64);
    }

    public CDoubleVectorBuilder(int initialCapacity) {
        this.elements = UnmanagedMemory.mallocCDoublePointer(initialCapacity);
        this.capacity = initialCapacity;
    }

    public void add(double value) {
        this.ensureCapacity(this.size + 1);
        this.elements.write(this.size, value);
        ++this.size;
    }

    public double get(int index) {
        Objects.checkIndex(index, this.size);
        return this.elements.read(index);
    }

    public void set(int index, double value) {
        Objects.checkIndex(index, this.size);
        this.elements.write(index, value);
    }

    public int size() {
        return this.size;
    }

    public void moveTo(CDoubleVector cDoubleVector) {
        if (this.size < 0) {
            throw new IllegalStateException("already moved");
        }
        cDoubleVector.elements(this.size == this.capacity ? this.elements : UnmanagedMemory.reallocCDoublePointer(this.elements, this.size));
        cDoubleVector.size(this.size);
        this.elements = (CDoublePointer)WordFactory.nullPointer();
        this.size = Integer.MIN_VALUE;
    }

    public double[] toArray() {
        int length = this.size;
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    private void ensureCapacity(int minCapacity) {
        if (this.capacity >= minCapacity) {
            return;
        }
        int newCapacity = ArraysSupport.newLength(this.capacity, minCapacity - this.capacity, this.capacity >> 1);
        this.elements = UnmanagedMemory.reallocCDoublePointer(this.elements, newCapacity);
        this.capacity = newCapacity;
    }
}

