/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import com.google.common.collect.HashBasedTable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import owl.collections.ImmutableBitSet;
import owl.ltl.BooleanConstant;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.Literal;
import owl.translations.canonical.DeterministicConstructions;

final class EquivalenceClassEncoder {
    private final Map<DeterministicConstructions.BreakpointStateRejecting, Integer> states = new HashMap<DeterministicConstructions.BreakpointStateRejecting, Integer>();
    @Nullable
    private Map<EquivalenceClass, ImmutableBitSet> allProfiles;
    @Nullable
    private Map<EquivalenceClass, ImmutableBitSet> rejectingProfiles;

    EquivalenceClassEncoder() {
    }

    void put(DeterministicConstructions.BreakpointStateRejecting state) {
        if (this.allProfiles != null) {
            throw new IllegalStateException("profiles already computed.");
        }
        this.states.put(state, -1);
    }

    void putAll(Collection<? extends DeterministicConstructions.BreakpointStateRejecting> newStates) {
        newStates.forEach(this::put);
    }

    ImmutableBitSet getAllProfile(DeterministicConstructions.BreakpointStateRejecting state) {
        this.initialise();
        assert (this.allProfiles != null);
        return this.allProfiles.get(state.all());
    }

    ImmutableBitSet getRejectingProfile(DeterministicConstructions.BreakpointStateRejecting state) {
        this.initialise();
        assert (this.rejectingProfiles != null);
        return this.rejectingProfiles.get(state.rejecting());
    }

    int disambiguation(DeterministicConstructions.BreakpointStateRejecting state) {
        this.initialise();
        int id = this.states.get(state);
        assert (id >= 0);
        return id;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<EquivalenceClass, ImmutableBitSet> computeProfiles(Set<EquivalenceClass> classes) {
        void var7_23;
        IdentityHashMap<EquivalenceClass, ImmutableBitSet> profiles = new IdentityHashMap<EquivalenceClass, ImmutableBitSet>(classes.size());
        TreeMap numbering = new TreeMap(Comparator.reverseOrder());
        for (EquivalenceClass equivalenceClass : classes) {
            HashSet<Formula.TemporalOperator> profile = new HashSet<Formula.TemporalOperator>(equivalenceClass.temporalOperators(false));
            equivalenceClass.substitute(x2 -> BooleanConstant.TRUE).atomicPropositions(false).stream().forEach(x -> profile.add((Formula.TemporalOperator)((Object)Literal.of(x, false))));
            equivalenceClass.substitute(x1 -> BooleanConstant.FALSE).atomicPropositions(false).stream().forEach(x -> profile.add((Formula.TemporalOperator)((Object)Literal.of(x, true))));
            profiles.put(equivalenceClass, (ImmutableBitSet)((Object)profile));
            for (Formula formula : profile) {
                assert (formula instanceof Literal || formula instanceof Formula.TemporalOperator);
                numbering.compute(formula, (y, counter) -> counter == null ? 1 : counter + 1);
            }
        }
        int size = profiles.size();
        boolean bl = false;
        Iterator iterator = numbering.entrySet().iterator();
        while (iterator.hasNext()) {
            void var4_9;
            Map.Entry entry2 = iterator.next();
            int n = (Integer)entry2.getValue();
            if (n == size) {
                iterator.remove();
                continue;
            }
            entry2.setValue((int)var4_9);
            ++var4_9;
        }
        for (Map.Entry entry2 : profiles.entrySet()) {
            BitSet bitsetProfile = new BitSet();
            Set profile = (Set)entry2.getValue();
            for (Formula formula : profile) {
                assert (formula instanceof Literal || formula instanceof Formula.TemporalOperator);
                Integer value = (Integer)numbering.get(formula);
                if (value == null) continue;
                bitsetProfile.set(value);
            }
            entry2.setValue(ImmutableBitSet.copyOf(bitsetProfile));
        }
        int variables = numbering.size();
        BitSet bitSet = new BitSet();
        for (int i = 0; i < variables; ++i) {
            for (int j = i + 1; j < variables; ++j) {
                if (bitSet.get(j)) continue;
                boolean bl2 = true;
                for (Set profile : profiles.values()) {
                    ImmutableBitSet castedProfile = (ImmutableBitSet)profile;
                    if (castedProfile.contains(i) == castedProfile.contains(j)) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                assert (!bitSet.get(j));
                bitSet.set(j);
            }
        }
        int[] mapping = new int[variables];
        int offset = 0;
        boolean bl3 = false;
        while (var7_23 < variables) {
            if (bitSet.get((int)var7_23)) {
                ++offset;
                mapping[var7_23] = -1;
            } else {
                mapping[var7_23] = var7_23 - offset;
                assert (mapping[var7_23] >= 0);
            }
            ++var7_23;
        }
        if (!bitSet.isEmpty()) {
            profiles.entrySet().forEach(entry -> {
                ImmutableBitSet profile = (ImmutableBitSet)entry.getValue();
                BitSet mappedProfile = new BitSet();
                profile.forEach(i -> {
                    int j = mapping[i];
                    if (j >= 0) {
                        mappedProfile.set(j);
                    }
                });
                entry.setValue(ImmutableBitSet.copyOf(mappedProfile));
            });
        }
        return profiles;
    }

    private void initialise() {
        if (this.allProfiles != null) {
            assert (this.rejectingProfiles != null);
            return;
        }
        HashSet<EquivalenceClass> allClasses = new HashSet<EquivalenceClass>(this.states.size());
        HashSet<EquivalenceClass> rejectingClasses = new HashSet<EquivalenceClass>(this.states.size());
        for (DeterministicConstructions.BreakpointStateRejecting state : this.states.keySet()) {
            allClasses.add(state.all());
            rejectingClasses.add(state.rejecting());
        }
        this.allProfiles = EquivalenceClassEncoder.computeProfiles(allClasses);
        this.rejectingProfiles = EquivalenceClassEncoder.computeProfiles(rejectingClasses);
        HashBasedTable ambiguousProfiles = HashBasedTable.create((int)this.allProfiles.size(), (int)this.rejectingProfiles.size());
        for (DeterministicConstructions.BreakpointStateRejecting state : this.states.keySet()) {
            ImmutableBitSet rejectingProfile;
            ImmutableBitSet allProfile = this.allProfiles.get(state.all());
            ArrayList<DeterministicConstructions.BreakpointStateRejecting> ambiguous = (ArrayList<DeterministicConstructions.BreakpointStateRejecting>)ambiguousProfiles.get((Object)allProfile, (Object)(rejectingProfile = this.rejectingProfiles.get(state.rejecting())));
            if (ambiguous == null) {
                ambiguous = new ArrayList<DeterministicConstructions.BreakpointStateRejecting>();
                ambiguousProfiles.put((Object)allProfile, (Object)rejectingProfile, ambiguous);
            }
            ambiguous.add(state);
        }
        for (List ambiguous : ambiguousProfiles.values()) {
            int counter = 0;
            for (DeterministicConstructions.BreakpointStateRejecting state : ambiguous) {
                Integer oldValue = this.states.put(state, counter);
                assert (oldValue != null && oldValue == -1);
                ++counter;
            }
        }
    }
}

