/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import com.google.common.collect.Streams;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import owl.collections.TrieMap;

public class HashTrieMap<K, V>
extends AbstractMap<List<K>, V>
implements TrieMap<K, V> {
    private final HashMap<K, HashTrieMap<K, V>> map = new HashMap();
    @Nullable
    private V value = null;
    @Nullable
    private EntrySet cachedEntrySet = null;

    @Override
    public boolean containsKeyWithPrefix(List<?> prefix) {
        HashTrieMap<K, V> subTrie = this.subTrieIfPresent(prefix);
        return subTrie != null && !subTrie.isEmpty();
    }

    @Override
    public Map<K, ? extends TrieMap<K, V>> subTries() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public HashTrieMap<K, V> subTrie(List<? extends K> prefix) {
        HashTrieMap subTrie = this;
        for (K key : prefix) {
            subTrie = subTrie.map.computeIfAbsent(Objects.requireNonNull(key), x -> new HashTrieMap());
        }
        return subTrie;
    }

    @Nullable
    private HashTrieMap<K, V> subTrieIfPresent(Object obj) {
        Objects.requireNonNull(obj);
        if (!(obj instanceof List)) {
            return null;
        }
        List prefix = (List)obj;
        HashTrieMap<K, V> subTrie = this;
        for (Object key : prefix) {
            subTrie = subTrie.map.get(Objects.requireNonNull(key));
            if (subTrie != null) continue;
            return null;
        }
        return subTrie;
    }

    @Override
    public boolean containsKey(Object key) {
        HashTrieMap<K, V> subTrie = this.subTrieIfPresent(key);
        return subTrie != null && subTrie.value != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value.equals(this.value)) {
            return true;
        }
        for (HashTrieMap<K, V> subTrie : this.map.values()) {
            if (!subTrie.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public V get(Object key) {
        HashTrieMap<K, V> subTrie = this.subTrieIfPresent(key);
        return subTrie == null ? null : (V)subTrie.value;
    }

    @Override
    public V put(List<K> key, V value) {
        TrieMap subTrie = this.subTrie(key);
        V oldValue = ((HashTrieMap)subTrie).value;
        ((HashTrieMap)subTrie).value = Objects.requireNonNull(value);
        return oldValue;
    }

    @Override
    @Nullable
    public V remove(Object key) {
        HashTrieMap<K, V> subTrie = this.subTrieIfPresent(key);
        if (subTrie == null) {
            return null;
        }
        V oldValue = subTrie.value;
        subTrie.value = null;
        return oldValue;
    }

    @Override
    public void clear() {
        this.value = null;
        this.map.values().forEach(HashTrieMap::clear);
    }

    @Override
    public boolean isEmpty() {
        return this.value == null && this.map.values().stream().allMatch(Map::isEmpty);
    }

    @Override
    public int size() {
        int size = this.value == null ? 0 : 1;
        for (HashTrieMap<K, V> subTrie : this.map.values()) {
            size += subTrie.size();
        }
        return size;
    }

    @Override
    public Set<Map.Entry<List<K>, V>> entrySet() {
        if (this.cachedEntrySet == null) {
            this.cachedEntrySet = new EntrySet();
        }
        return this.cachedEntrySet;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<List<K>, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<List<K>, V>> iterator() {
            return this.stream().iterator();
        }

        @Override
        public Stream<Map.Entry<List<K>, V>> stream() {
            Stream childrenStream = HashTrieMap.this.map.entrySet().stream().flatMap(x -> ((HashTrieMap)x.getValue()).entrySet().stream().map(y -> {
                ArrayList newKey = new ArrayList();
                newKey.add(x.getKey());
                newKey.addAll((Collection)y.getKey());
                return Map.entry(newKey, y.getValue());
            }));
            if (HashTrieMap.this.value == null) {
                return childrenStream;
            }
            return Streams.concat((Stream[])new Stream[]{Stream.of(Map.entry(List.of(), HashTrieMap.this.value)), childrenStream});
        }

        @Override
        public void clear() {
            HashTrieMap.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return HashTrieMap.this.isEmpty();
        }

        @Override
        public int size() {
            return HashTrieMap.this.size();
        }
    }
}

