/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import com.google.auto.value.AutoValue;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.collections.AutoValue_NullablePair;

@AutoValue
public abstract class NullablePair<A, B> {
    @Nullable
    public abstract A fst();

    @Nullable
    public abstract B snd();

    public static <A, B> NullablePair<A, B> of(@Nullable A fst, @Nullable B snd) {
        return new AutoValue_NullablePair<A, B>(fst, snd);
    }

    public static <A, B> Set<NullablePair<A, B>> allPairs(Set<A> fstSet, Set<B> sndSet) {
        HashSet<NullablePair<A, B>> pairs = new HashSet<NullablePair<A, B>>();
        for (A fst : fstSet) {
            for (B snd : sndSet) {
                pairs.add(NullablePair.of(fst, snd));
            }
        }
        return pairs;
    }

    public final NullablePair<B, A> swap() {
        return NullablePair.of(this.snd(), this.fst());
    }

    public final <C> NullablePair<C, B> mapFst(Function<A, C> mapper) {
        return NullablePair.of(mapper.apply(this.fst()), this.snd());
    }

    public final <C> NullablePair<A, C> mapSnd(Function<B, C> mapper) {
        return NullablePair.of(this.fst(), mapper.apply(this.snd()));
    }

    public final String toString() {
        return String.format("(%s, %s)", this.fst(), this.snd());
    }
}

