/*
 * Decompiled with CFR 0.152.
 */
package owl.command;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAIntermediateStoreAndManipulate;
import jhoafparser.extensions.HOAConsumerPrintFixed;
import jhoafparser.extensions.ToStateAcceptanceFixed;
import jhoafparser.parser.generated.ParseException;
import jhoafparser.storage.StoredAutomatonManipulator;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import owl.automaton.Automaton;
import owl.automaton.Views;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.hoa.HoaReader;
import owl.automaton.hoa.HoaWriter;
import owl.bdd.FactorySupplier;
import owl.ltl.LabelledFormula;
import owl.ltl.parser.LtlParser;
import owl.ltl.visitors.PrintVisitor;
import picocli.CommandLine;

final class Mixins {
    private Mixins() {
    }

    static final class Diagnostics {
        private final Stopwatch stopwatch = Stopwatch.createUnstarted();
        @CommandLine.Option(names={"--diagnostics"}, description={"Print diagnostic information to stderr."})
        private boolean printDiagnostics = false;
        @CommandLine.Option(names={"--diagnostics-time-unit"}, description={"Select the time unit (${COMPLETION-CANDIDATES}) for reporting runtimes. The default value is ${DEFAULT-VALUE}. Be aware that for NANOSECONDS the reporting might not be accurate."}, defaultValue="MILLISECONDS")
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

        Diagnostics() {
        }

        void start(String subcommand, Automaton<?, ?> automaton) {
            if (this.printDiagnostics) {
                System.err.printf("%s:\n  Input Automaton (after preprocessing):\n    States: %d\n    Acceptance Name: %s\n    Acceptance Sets: %d\n", subcommand, automaton.states().size(), ((EmersonLeiAcceptance)automaton.acceptance()).name(), ((EmersonLeiAcceptance)automaton.acceptance()).acceptanceSets());
                this.stopwatch.start();
            }
        }

        void finish(Automaton<?, ?> automaton) {
            if (this.printDiagnostics) {
                this.stopwatch.stop();
                System.err.printf("  Output Automaton (before postprocessing):\n    States: %d\n    Acceptance Name: %s\n    Acceptance Sets: %d\n  Runtime (without pre- and postprocessing): %d %s\n", new Object[]{automaton.states().size(), ((EmersonLeiAcceptance)automaton.acceptance()).name(), ((EmersonLeiAcceptance)automaton.acceptance()).acceptanceSets(), this.stopwatch.elapsed(this.timeUnit), this.timeUnit});
            }
        }
    }

    static final class Verifier {
        @CommandLine.Option(names={"--verify"}, description={"Verify the computed result. If the verification fails the tool aborts with an error. This flag is intended only for testing."}, hidden=true)
        boolean verify = false;

        Verifier() {
        }
    }

    static final class FormulaSimplifier {
        @CommandLine.Option(names={"--skip-formula-simplifier"}, description={"Bypass the automatic simplification of formulas."})
        boolean skipSimplifier = false;

        FormulaSimplifier() {
        }
    }

    static final class AcceptanceSimplifier {
        @CommandLine.Option(names={"--skip-acceptance-simplifier"}, description={"Bypass the automatic simplification of automata acceptance conditions."})
        boolean skipAcceptanceSimplifier = false;

        AcceptanceSimplifier() {
        }
    }

    static final class FormulaWriter {
        @CommandLine.Option(names={"-o", "--output-file"}, description={"Output file (default: write to stdout). If '-' is specified, then the tool writes to stdout."})
        private String formulaFile = null;

        FormulaWriter() {
        }

        Sink sink() throws IOException {
            return new Sink();
        }

        final class Sink
        implements AutoCloseable {
            private final BufferedWriter writer;

            private Sink() throws IOException {
                if ("-".equals(FormulaWriter.this.formulaFile)) {
                    FormulaWriter.this.formulaFile = null;
                }
                this.writer = FormulaWriter.this.formulaFile == null ? new BufferedWriter(new OutputStreamWriter(System.out)) : Files.newBufferedWriter(Path.of(FormulaWriter.this.formulaFile, new String[0]), new OpenOption[0]);
            }

            void accept(LabelledFormula labelledFormula) throws IOException {
                this.writer.write(PrintVisitor.toString(labelledFormula, true));
                this.writer.write(System.lineSeparator());
                this.writer.flush();
            }

            @Override
            public void close() throws IOException {
                this.writer.close();
            }
        }
    }

    static final class FormulaReader {
        @CommandLine.ArgGroup
        private Source source = null;

        FormulaReader() {
        }

        Stream<String> stringSource() throws IOException {
            Stream<String> stringStream;
            if (this.source == null) {
                this.source = new Source();
                this.source.formulaFile = new String[]{"-"};
            }
            if (this.source.formulaFile == null) {
                assert (this.source.formula != null);
                stringStream = Stream.of(this.source.formula);
            } else {
                ArrayList<Stream> readerStreams = new ArrayList<Stream>(this.source.formulaFile.length);
                for (String file : this.source.formulaFile) {
                    BufferedReader reader = "-".equals(file) ? new BufferedReader(new InputStreamReader(System.in)) : Files.newBufferedReader(Path.of(file, new String[0]));
                    readerStreams.add((Stream)reader.lines().onClose(() -> {
                        try {
                            reader.close();
                        }
                        catch (IOException ex) {
                            throw new UncheckedIOException(ex);
                        }
                    }));
                }
                stringStream = readerStreams.size() == 1 ? (Stream)readerStreams.get(0) : readerStreams.stream().flatMap(Function.identity());
            }
            return stringStream.filter(Predicate.not(String::isBlank));
        }

        Stream<LabelledFormula> source() throws IOException {
            return this.stringSource().map(line -> {
                try {
                    return LtlParser.parse(line);
                }
                catch (RecognitionException | ParseCancellationException ex) {
                    throw new IllegalArgumentException((String)line, ex);
                }
            });
        }

        private static final class Source {
            @CommandLine.Option(names={"-f", "--formula"}, description={"Use the argument of the option as the input formula. This option is repeatable, but cannot be combined with '-i'."})
            String[] formula = null;
            @CommandLine.Option(names={"-i", "--input-file"}, description={"Input file (default: read from stdin). The file is read line-by-line and it is assumed that each line contains a formula. Empty lines are skipped. If '-' is specified, then the tool reads from stdin. This option is repeatable, but cannot be combined with '-f'."})
            String[] formulaFile = null;

            private Source() {
            }
        }
    }

    static final class AutomatonWriter {
        @CommandLine.Option(names={"-o", "--output-file"}, description={"Output file (default: write to stdout). If '-' is specified, then the tool writes to stdout."})
        private String automatonFile = null;
        @CommandLine.Option(names={"--complete"}, description={"Output an automaton with a complete transition relation."})
        boolean complete = false;
        @CommandLine.Option(names={"--dry-run"}, description={"Do not output resulting automaton."})
        private boolean dryRun = false;
        @CommandLine.Option(names={"--state-acceptance"}, description={"Output an automaton with a state-based acceptance condition instead of one with a transition-based acceptance condition. For this the acceptance marks of edges are pushed onto the successor states. However, this simple procedure might yield suboptimal results."})
        private boolean stateAcceptance = false;
        @CommandLine.Option(names={"--state-labels"}, description={"Annotate each state of the automaton with the 'toString()' method."})
        private boolean stateLabels = false;

        AutomatonWriter() {
        }

        Sink sink(String subcommand, List<String> subcommandArgs) throws IOException {
            return new Sink(subcommand, subcommandArgs);
        }

        class Sink
        implements AutoCloseable {
            private final BufferedWriter writer;
            private final String subcommand;
            private final List<String> subcommandArgs;

            private Sink(String subcommand, List<String> subcommandArgs) throws IOException {
                if ("-".equals(AutomatonWriter.this.automatonFile)) {
                    AutomatonWriter.this.automatonFile = null;
                }
                this.writer = AutomatonWriter.this.automatonFile == null ? new BufferedWriter(new OutputStreamWriter(System.out)) : Files.newBufferedWriter(Path.of(AutomatonWriter.this.automatonFile, new String[0]), new OpenOption[0]);
                this.subcommand = subcommand;
                this.subcommandArgs = List.copyOf(subcommandArgs);
            }

            void accept(Automaton<?, ?> automaton, String automatonName) throws HOAConsumerException, IOException {
                if (AutomatonWriter.this.dryRun) {
                    return;
                }
                if (AutomatonWriter.this.complete && !automaton.is(Automaton.Property.COMPLETE)) {
                    automaton = Views.complete(automaton);
                }
                HOAConsumerPrintFixed printer = new HOAConsumerPrintFixed(this.writer);
                HOAConsumerPrintFixed wrappedPrinter = AutomatonWriter.this.stateAcceptance ? new HOAIntermediateStoreAndManipulate((HOAConsumer)printer, new StoredAutomatonManipulator[]{new ToStateAcceptanceFixed()}) : printer;
                HoaWriter.write(automaton, wrappedPrinter, AutomatonWriter.this.stateLabels, this.subcommand, this.subcommandArgs, automatonName);
                this.writer.flush();
            }

            @Override
            public void close() throws IOException {
                this.writer.close();
            }
        }
    }

    static final class AutomatonReader {
        @CommandLine.Option(names={"-i", "--input-file"}, description={"Input file (default: read from stdin). If '-' is specified, then the tool reads from stdin. This option is repeatable."})
        private String[] automatonFile = new String[]{"-"};

        AutomatonReader() {
        }

        <A extends EmersonLeiAcceptance> Stream<Automaton<Integer, ? extends A>> source(Class<A> acceptanceClass) {
            return Stream.of(this.automatonFile).flatMap(file -> {
                Stream stream;
                block9: {
                    BufferedReader reader = "-".equals(file) ? new BufferedReader(new InputStreamReader(System.in)) : Files.newBufferedReader(Path.of(file, new String[0]));
                    try {
                        ArrayList automata = new ArrayList();
                        HoaReader.readStream(reader, FactorySupplier.defaultSupplier()::getBddSetFactory, null, automaton -> {
                            Preconditions.checkArgument((boolean)OmegaAcceptanceCast.isInstanceOf(automaton.acceptance().getClass(), acceptanceClass), (Object)String.format("Expected %s, but got %s.", acceptanceClass, automaton.acceptance()));
                            automata.add(OmegaAcceptanceCast.cast(automaton, acceptanceClass));
                        });
                        stream = automata.stream();
                        if (reader == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        catch (ParseException e) {
                            throw new UncheckedExecutionException((Throwable)e);
                        }
                    }
                    reader.close();
                }
                return stream;
            });
        }
    }
}

