/*
 * Decompiled with CFR 0.152.
 */
package owl.game;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToIntFunction;
import owl.automaton.AnnotatedState;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.game.AutoValue_PgSolverFormat_PriorityState;
import owl.game.Game;

public final class PgSolverFormat {
    private PgSolverFormat() {
    }

    public static <S> void write(Game<S, ? extends ParityAcceptance> game, PrintWriter output, boolean names) {
        ParityAcceptance acceptance = (ParityAcceptance)game.acceptance();
        Preconditions.checkArgument((acceptance.parity() == ParityAcceptance.Parity.MAX_EVEN ? 1 : 0) != 0, (Object)"Invalid acceptance");
        Preconditions.checkArgument((game.initialStates().size() == 1 ? 1 : 0) != 0, (Object)"Multiple initial states not supported");
        HashMap<PriorityState, Integer> stateNumbering = new HashMap<PriorityState, Integer>();
        int highestPriority = acceptance.acceptanceSets() - 1;
        Object initialState = game.initialState();
        stateNumbering.put(PriorityState.of(initialState, highestPriority), 0);
        HashSet reachedStates = new HashSet(List.of(initialState));
        ArrayDeque workQueue = new ArrayDeque(reachedStates);
        ToIntFunction<Edge> getAcceptance = edge -> edge.colours().first().orElse(-1) + 1;
        while (!workQueue.isEmpty()) {
            Object state = workQueue.poll();
            Set edges = game.edges(state);
            Preconditions.checkArgument((!edges.isEmpty() ? 1 : 0) != 0, (Object)"Provided game is not complete");
            for (Edge edge2 : edges) {
                Object successor = edge2.successor();
                int stateAcceptance = getAcceptance.applyAsInt(edge2);
                PriorityState prioritySuccessor = PriorityState.of(successor, stateAcceptance);
                stateNumbering.putIfAbsent(prioritySuccessor, stateNumbering.size());
                if (!reachedStates.add(successor)) continue;
                workQueue.add(successor);
            }
        }
        int stateCount = stateNumbering.size();
        output.print("parity ");
        output.print(stateCount);
        output.println(";");
        stateNumbering.forEach((priorityState, identifier) -> {
            output.print(identifier);
            output.print(' ');
            output.print(priorityState.acceptance());
            output.print(' ');
            output.print(game.owner(priorityState.state()) == Game.Owner.PLAYER_1 ? 0 : 1);
            Iterator iterator = game.edges(priorityState.state()).iterator();
            if (iterator.hasNext()) {
                output.print(' ');
                boolean first = true;
                HashSet<Integer> printedIndices = new HashSet<Integer>();
                while (iterator.hasNext()) {
                    int stateAcceptance;
                    Edge edge = iterator.next();
                    Object successor = edge.successor();
                    Integer successorIndex = (Integer)stateNumbering.get(PriorityState.of(successor, stateAcceptance = getAcceptance.applyAsInt(edge)));
                    if (!printedIndices.add(Objects.requireNonNull(successorIndex))) continue;
                    assert (successorIndex >= 0);
                    if (!first) {
                        output.print(',');
                    }
                    first = false;
                    output.print(successorIndex);
                }
            }
            if (names) {
                output.print(" \"");
                output.print(priorityState.state());
                output.print(" (");
                output.print(priorityState.acceptance());
                output.print(")\"");
            }
            output.println(';');
        });
        output.flush();
    }

    @AutoValue
    static abstract class PriorityState<S>
    implements AnnotatedState<S> {
        PriorityState() {
        }

        @Override
        public abstract S state();

        abstract int acceptance();

        static <S> PriorityState<S> of(S state, int acceptance) {
            return new AutoValue_PgSolverFormat_PriorityState<S>(state, acceptance);
        }
    }
}

