/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.MOperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class FOperator
extends Formula.UnaryTemporalOperator {
    public FOperator(Formula operand) {
        super(FOperator.class, operand);
    }

    public static Formula of(Formula operand) {
        if (operand instanceof BooleanConstant || operand instanceof FOperator || operand instanceof GOperator && ((GOperator)operand).operand() instanceof FOperator) {
            return operand;
        }
        if (operand instanceof Disjunction) {
            return Disjunction.of(((Disjunction)operand).map(FOperator::of));
        }
        if (operand instanceof MOperator) {
            MOperator mOperator = (MOperator)operand;
            return FOperator.of(Conjunction.of(mOperator.leftOperand(), mOperator.rightOperand()));
        }
        if (operand instanceof UOperator) {
            return FOperator.of(((UOperator)operand).rightOperand());
        }
        if (operand instanceof WOperator) {
            WOperator wOperator = (WOperator)operand;
            return Disjunction.of(FOperator.of(GOperator.of(wOperator.leftOperand())), FOperator.of(wOperator.rightOperand()));
        }
        return new FOperator(operand);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public String operatorSymbol() {
        return "F";
    }

    @Override
    public boolean isPureEventual() {
        return true;
    }

    @Override
    public boolean isPureUniversal() {
        return this.operand().isPureUniversal();
    }

    @Override
    public Formula nnf() {
        if (this.operand() instanceof Biconditional) {
            Formula left = ((Biconditional)this.operand()).leftOperand().nnf();
            Formula right = ((Biconditional)this.operand()).rightOperand().nnf();
            return Disjunction.of(FOperator.of(Conjunction.of(left, right)), FOperator.of(Conjunction.of(left.not(), right.not())));
        }
        return FOperator.of(this.operand().nnf());
    }

    @Override
    public Formula not() {
        return GOperator.of(this.operand().not());
    }

    @Override
    public Formula unfold() {
        return Disjunction.of(this.operand().unfold(), (Formula)this);
    }
}

