/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.util.List;
import owl.collections.Collections3;
import owl.ltl.AutoValue_LabelledFormula;
import owl.ltl.Formula;
import owl.ltl.visitors.PrintVisitor;

@AutoValue
public abstract class LabelledFormula {
    public abstract List<String> atomicPropositions();

    public abstract Formula formula();

    public static LabelledFormula of(Formula formula, List<String> atomicPropositions) {
        int atomicPropositionsSize = formula.atomicPropositions(true).length();
        Preconditions.checkArgument((boolean)Collections3.isDistinct(atomicPropositions));
        Preconditions.checkArgument((atomicPropositionsSize <= atomicPropositions.size() ? 1 : 0) != 0);
        if (atomicPropositionsSize == atomicPropositions.size()) {
            return new AutoValue_LabelledFormula(List.copyOf(atomicPropositions), formula);
        }
        return new AutoValue_LabelledFormula(List.copyOf(atomicPropositions.subList(0, atomicPropositionsSize)), formula);
    }

    public LabelledFormula wrap(Formula formula) {
        return LabelledFormula.of(formula, this.atomicPropositions());
    }

    public LabelledFormula not() {
        return this.wrap(this.formula().not());
    }

    public LabelledFormula nnf() {
        return this.wrap(this.formula().nnf());
    }

    public String toString() {
        return PrintVisitor.toString(this, true);
    }
}

