/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import com.google.common.base.Preconditions;
import owl.ltl.BooleanConstant;
import owl.ltl.Formula;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class XOperator
extends Formula.UnaryTemporalOperator {
    public XOperator(Formula operand) {
        super(XOperator.class, operand);
    }

    public static Formula of(Formula operand) {
        return XOperator.of(operand, 1);
    }

    public static Formula of(Formula operand, int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"n must be non-negative.");
        if (operand instanceof BooleanConstant) {
            return operand;
        }
        Formula formula = operand;
        for (int i = 0; i < n; ++i) {
            formula = new XOperator(formula);
        }
        return formula;
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public String operatorSymbol() {
        return "X";
    }

    @Override
    public boolean isPureEventual() {
        return this.operand().isPureEventual();
    }

    @Override
    public boolean isPureUniversal() {
        return this.operand().isPureUniversal();
    }

    @Override
    public Formula nnf() {
        return XOperator.of(this.operand().nnf());
    }

    @Override
    public Formula not() {
        return XOperator.of(this.operand().not());
    }

    @Override
    public Formula unfold() {
        return this;
    }
}

