/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import owl.grammar.LTLLexer;
import owl.grammar.LTLParser;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.parser.LtlfParseTreeVisitor;
import owl.ltl.parser.LtlfToLtlTranslator;
import owl.ltl.parser.TokenErrorListener;

public final class LtlfParser {
    private LtlfParser() {
    }

    public static LabelledFormula parse(String formula) {
        return LtlfParser.parse(formula, null);
    }

    public static LabelledFormula parse(String formula, @Nullable List<String> atomicPropositions) {
        LTLLexer lexer = new LTLLexer((CharStream)CharStreams.fromString((String)formula));
        lexer.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        lexer.addErrorListener((ANTLRErrorListener)new TokenErrorListener());
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        LTLParser parser = new LTLParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        LtlfParseTreeVisitor treeVisitor = atomicPropositions == null ? new LtlfParseTreeVisitor() : new LtlfParseTreeVisitor(atomicPropositions);
        return LabelledFormula.of((Formula)treeVisitor.visit((ParseTree)parser.formula()), treeVisitor.atomicPropositions());
    }

    public static LabelledFormula parseAndTranslateToLtl(String formula) {
        return LtlfParser.parseAndTranslateToLtl(formula, null);
    }

    public static LabelledFormula parseAndTranslateToLtl(String formula, @Nullable List<String> atomicPropositions) {
        LabelledFormula ltlf = LtlfParser.parse(formula, atomicPropositions);
        Formula ltl = LtlfToLtlTranslator.translate(ltlf.formula(), ltlf.atomicPropositions().size());
        Random randomID = new Random();
        ArrayList<String> atomicPropositionsWithTail = new ArrayList<String>(ltlf.atomicPropositions());
        if (!atomicPropositionsWithTail.contains("tail")) {
            atomicPropositionsWithTail.add("tail");
        }
        while (ltlf.atomicPropositions().size() == atomicPropositionsWithTail.size()) {
            String tail = "tail_" + randomID.nextInt();
            if (atomicPropositionsWithTail.contains(tail)) continue;
            atomicPropositionsWithTail.add(tail);
        }
        return LabelledFormula.of(ltl, atomicPropositionsWithTail);
    }
}

