/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.Negation;
import owl.ltl.ROperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.visitors.Converter;
import owl.ltl.visitors.PropositionalVisitor;

public class PropositionalSimplifier
extends Converter {
    public static final PropositionalSimplifier INSTANCE = new PropositionalSimplifier();
    private static final boolean DISABLE_EXPENSIVE_ASSERT = true;

    protected PropositionalSimplifier() {
        super(SyntacticFragment.ALL);
    }

    @Override
    public Formula visit(Conjunction conjunction) {
        Formula newConjunction = super.visit(conjunction);
        if (!(newConjunction instanceof Conjunction)) {
            return newConjunction;
        }
        ArrayList<Formula> combined = new ArrayList<Formula>();
        HashSet<Formula> trueUnits = new HashSet<Formula>();
        HashSet<Formula> falseUnits = new HashSet<Formula>();
        for (Formula formula : newConjunction.operands) {
            if (formula instanceof Literal || formula instanceof Formula.TemporalOperator) {
                if (falseUnits.contains(formula)) {
                    return BooleanConstant.FALSE;
                }
                trueUnits.add(formula);
                falseUnits.add(formula.not());
                continue;
            }
            combined.add(formula);
        }
        combined.replaceAll(combinedFormula -> combinedFormula.accept(new ConjunctionVisitor(trueUnits, falseUnits)));
        combined.addAll(trueUnits);
        newConjunction = Conjunction.of(combined);
        if (newConjunction instanceof Conjunction) {
            if (newConjunction.operands.stream().allMatch(Disjunction.class::isInstance)) {
                ArrayList<Formula> candidates = null;
                for (Formula operand : newConjunction.operands) {
                    assert (operand instanceof Disjunction);
                    if (candidates == null) {
                        candidates = new ArrayList<Formula>(operand.operands);
                    } else {
                        candidates.removeIf(x -> !operand.operands.contains(x));
                    }
                    if (!candidates.isEmpty()) continue;
                    candidates = null;
                    break;
                }
                if (candidates != null) {
                    ArrayList<Formula> arrayList = candidates;
                    List prunedDisjuncts = newConjunction.operands.stream().map(x -> Disjunction.of(x.operands.stream().filter(y -> !finalCandidates.contains(y)))).collect(Collectors.toList());
                    arrayList.add(Conjunction.of(prunedDisjuncts));
                    newConjunction = Disjunction.of(arrayList);
                    return newConjunction;
                }
            }
        }
        return newConjunction;
    }

    @Override
    public Formula visit(Disjunction disjunction) {
        Formula newDisjunction = super.visit(disjunction);
        if (!(newDisjunction instanceof Disjunction)) {
            return newDisjunction;
        }
        ArrayList<Formula> combined = new ArrayList<Formula>();
        HashSet<Formula> trueUnits = new HashSet<Formula>();
        HashSet<Formula> falseUnits = new HashSet<Formula>();
        for (Formula formula : newDisjunction.operands) {
            if (formula instanceof Literal || formula instanceof Formula.TemporalOperator) {
                if (falseUnits.contains(formula)) {
                    return BooleanConstant.TRUE;
                }
                trueUnits.add(formula);
                falseUnits.add(formula.not());
                continue;
            }
            combined.add(formula);
        }
        combined.replaceAll(combinedFormula -> combinedFormula.accept(new DisjunctionVisitor(trueUnits, falseUnits)));
        combined.addAll(trueUnits);
        newDisjunction = Disjunction.of(combined);
        if (newDisjunction instanceof Disjunction) {
            if (newDisjunction.operands.stream().allMatch(Conjunction.class::isInstance)) {
                ArrayList<Formula> candidates = null;
                for (Formula operand : newDisjunction.operands) {
                    assert (operand instanceof Conjunction);
                    if (candidates == null) {
                        candidates = new ArrayList<Formula>(operand.operands);
                    } else {
                        candidates.removeIf(x -> !operand.operands.contains(x));
                    }
                    if (!candidates.isEmpty()) continue;
                    candidates = null;
                    break;
                }
                if (candidates != null) {
                    ArrayList<Formula> arrayList = candidates;
                    List prunedConjuncts = newDisjunction.operands.stream().map(x -> Conjunction.of(x.operands.stream().filter(y -> !finalCandidates.contains(y)))).collect(Collectors.toList());
                    arrayList.add(Disjunction.of(prunedConjuncts));
                    newDisjunction = Conjunction.of(arrayList);
                    return newDisjunction;
                }
            }
        }
        return newDisjunction;
    }

    private static class DisjunctionVisitor
    extends PropositionalVisitor<Formula> {
        private final Set<Formula> trueUnits;
        private final Set<Formula> falseUnits;

        public DisjunctionVisitor(Set<Formula> trueUnits, Set<Formula> falseUnits) {
            this.trueUnits = trueUnits;
            this.falseUnits = falseUnits;
        }

        @Override
        protected Formula visit(Formula.TemporalOperator formula) {
            if (this.trueUnits.contains(formula) || formula instanceof GOperator && this.trueUnits.contains(((GOperator)formula).operand()) || formula instanceof ROperator && this.trueUnits.contains(((ROperator)formula).rightOperand()) || formula instanceof MOperator && this.trueUnits.contains(((MOperator)formula).rightOperand())) {
                return BooleanConstant.FALSE;
            }
            if (this.falseUnits.contains(formula) || formula instanceof FOperator && this.falseUnits.contains(((FOperator)formula).operand()) || formula instanceof UOperator && this.falseUnits.contains(((UOperator)formula).rightOperand()) || formula instanceof WOperator && this.falseUnits.contains(((WOperator)formula).rightOperand())) {
                return BooleanConstant.TRUE;
            }
            return formula;
        }

        @Override
        public Formula visit(Literal literal) {
            if (this.trueUnits.contains(literal)) {
                return BooleanConstant.FALSE;
            }
            if (this.falseUnits.contains(literal)) {
                return BooleanConstant.TRUE;
            }
            return literal;
        }

        @Override
        public Formula visit(Biconditional biconditional) {
            return Biconditional.of(biconditional.leftOperand().accept(this), biconditional.rightOperand().accept(this));
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant) {
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction) {
            return Conjunction.of(conjunction.map(x -> x.accept(this)));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            return Disjunction.of(disjunction.map(x -> x.accept(this)));
        }

        @Override
        public Formula visit(Negation negation) {
            return new Negation(negation.operand().accept(this));
        }
    }

    private static class ConjunctionVisitor
    extends PropositionalVisitor<Formula> {
        private final Set<Formula> trueUnits;
        private final Set<Formula> falseUnits;

        public ConjunctionVisitor(Set<Formula> trueUnits, Set<Formula> falseUnits) {
            this.trueUnits = trueUnits;
            this.falseUnits = falseUnits;
        }

        @Override
        protected Formula visit(Formula.TemporalOperator formula) {
            if (this.trueUnits.contains(formula) || formula instanceof FOperator && this.trueUnits.contains(((FOperator)formula).operand()) || formula instanceof UOperator && this.trueUnits.contains(((UOperator)formula).rightOperand()) || formula instanceof WOperator && this.trueUnits.contains(((WOperator)formula).rightOperand())) {
                return BooleanConstant.TRUE;
            }
            if (this.falseUnits.contains(formula) || formula instanceof GOperator && this.falseUnits.contains(((GOperator)formula).operand()) || formula instanceof ROperator && this.falseUnits.contains(((ROperator)formula).rightOperand()) || formula instanceof MOperator && this.falseUnits.contains(((MOperator)formula).rightOperand())) {
                return BooleanConstant.FALSE;
            }
            return formula;
        }

        @Override
        public Formula visit(Literal literal) {
            if (this.trueUnits.contains(literal)) {
                return BooleanConstant.TRUE;
            }
            if (this.falseUnits.contains(literal)) {
                return BooleanConstant.FALSE;
            }
            return literal;
        }

        @Override
        public Formula visit(Biconditional biconditional) {
            return Biconditional.of(biconditional.leftOperand().accept(this), biconditional.rightOperand().accept(this));
        }

        @Override
        public Formula visit(BooleanConstant booleanConstant) {
            return booleanConstant;
        }

        @Override
        public Formula visit(Conjunction conjunction) {
            return Conjunction.of(conjunction.map(x -> x.accept(this)));
        }

        @Override
        public Formula visit(Disjunction disjunction) {
            return Disjunction.of(disjunction.map(x -> x.accept(this)));
        }

        @Override
        public Formula visit(Negation negation) {
            return new Negation(negation.operand().accept(this));
        }
    }
}

