/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.Visitor;

final class PullUpXVisitor
implements Visitor<XFormula> {
    static final PullUpXVisitor INSTANCE = new PullUpXVisitor();

    private PullUpXVisitor() {
    }

    @Override
    public XFormula visit(Biconditional biconditional) {
        XFormula right = biconditional.rightOperand().accept(this);
        XFormula left = biconditional.leftOperand().accept(this);
        left.formula = Biconditional.of(left.toFormula(right.depth), right.toFormula(left.depth));
        left.depth = Math.min(left.depth, right.depth);
        return left;
    }

    @Override
    public XFormula visit(BooleanConstant booleanConstant) {
        return new XFormula(0, booleanConstant);
    }

    @Override
    public XFormula visit(Conjunction conjunction) {
        List children = conjunction.operands.stream().map(c -> c.accept(this)).collect(Collectors.toList());
        int depth = children.stream().mapToInt(c -> c.depth).min().orElse(0);
        return new XFormula(depth, Conjunction.of(children.stream().map(c -> c.toFormula(depth))));
    }

    @Override
    public XFormula visit(Disjunction disjunction) {
        List children = disjunction.operands.stream().map(c -> c.accept(this)).collect(Collectors.toList());
        int depth = children.stream().mapToInt(c -> c.depth).min().orElse(0);
        return new XFormula(depth, Disjunction.of(children.stream().map(c -> c.toFormula(depth))));
    }

    @Override
    public XFormula visit(FOperator fOperator) {
        return this.visit(fOperator, FOperator::of);
    }

    @Override
    public XFormula visit(GOperator gOperator) {
        return this.visit(gOperator, GOperator::of);
    }

    @Override
    public XFormula visit(Literal literal) {
        return new XFormula(0, literal);
    }

    @Override
    public XFormula visit(MOperator mOperator) {
        return this.visit(mOperator, MOperator::of);
    }

    @Override
    public XFormula visit(ROperator rOperator) {
        return this.visit(rOperator, ROperator::of);
    }

    @Override
    public XFormula visit(UOperator uOperator) {
        return this.visit(uOperator, UOperator::of);
    }

    @Override
    public XFormula visit(WOperator wOperator) {
        return this.visit(wOperator, WOperator::of);
    }

    @Override
    public XFormula visit(XOperator xOperator) {
        XFormula r = xOperator.operand().accept(this);
        ++r.depth;
        return r;
    }

    private XFormula visit(Formula.BinaryTemporalOperator operator, BiFunction<Formula, Formula, Formula> constructor) {
        XFormula right = operator.rightOperand().accept(this);
        XFormula left = operator.leftOperand().accept(this);
        left.formula = constructor.apply(left.toFormula(right.depth), right.toFormula(left.depth));
        left.depth = Math.min(left.depth, right.depth);
        return left;
    }

    private XFormula visit(Formula.UnaryTemporalOperator operator, Function<Formula, Formula> constructor) {
        XFormula formula = operator.operand().accept(this);
        formula.formula = constructor.apply(formula.formula);
        return formula;
    }

    static final class XFormula {
        private int depth;
        private Formula formula;

        private XFormula(int depth, Formula formula) {
            this.depth = depth;
            this.formula = formula;
        }

        Formula toFormula(int newDepth) {
            Formula formula = this.formula;
            for (int i = this.depth - newDepth; i > 0; --i) {
                formula = XOperator.of(formula);
            }
            return formula;
        }

        Formula toFormula() {
            return this.toFormula(0);
        }
    }
}

