/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.robust;

import com.google.auto.value.AutoValue;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import owl.ltl.BooleanConstant;
import owl.ltl.Formula;
import owl.ltl.robust.AutoValue_Split;
import owl.ltl.robust.Robustness;

@AutoValue
public abstract class Split {
    public static final Split TRUE = Split.of(BooleanConstant.TRUE, true);
    public static final Split FALSE = Split.of(BooleanConstant.FALSE, true);

    public abstract Formula always();

    public abstract Formula eventuallyAlways();

    public abstract Formula infinitelyOften();

    public abstract Formula eventually();

    abstract boolean grFree();

    static Split of(Formula formula, boolean grFree) {
        return new AutoValue_Split(formula, formula, formula, formula, grFree);
    }

    static Split of(Formula first, Formula second, Formula third, Formula fourth, boolean grFree) {
        return new AutoValue_Split(first, second, third, fourth, grFree);
    }

    public static BinaryOperator<Split> combiner(BinaryOperator<Formula> formulaCombiner) {
        return (one, other) -> Split.of((Formula)formulaCombiner.apply(one.always(), other.always()), (Formula)formulaCombiner.apply(one.eventuallyAlways(), other.eventuallyAlways()), (Formula)formulaCombiner.apply(one.infinitelyOften(), other.infinitelyOften()), (Formula)formulaCombiner.apply(one.eventually(), other.eventually()), one.grFree() && other.grFree());
    }

    public Split map(UnaryOperator<Formula> map) {
        return this.map(map, this.grFree());
    }

    public Split map(UnaryOperator<Formula> map, boolean grFree) {
        return Split.of((Formula)map.apply(this.always()), (Formula)map.apply(this.eventuallyAlways()), (Formula)map.apply(this.infinitelyOften()), (Formula)map.apply(this.eventually()), grFree);
    }

    public List<Formula> all() {
        return List.of(this.always(), this.eventuallyAlways(), this.infinitelyOften(), this.eventually());
    }

    public Formula get(Robustness level) {
        switch (level) {
            case ALWAYS: {
                return this.always();
            }
            case EVENTUALLY_ALWAYS: {
                return this.eventuallyAlways();
            }
            case INFINITELY_OFTEN: {
                return this.infinitelyOften();
            }
            case EVENTUALLY: {
                return this.eventually();
            }
            case NEVER: {
                return this.eventually().not();
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        return "G: " + this.always() + " FG: " + this.eventuallyAlways() + " GF: " + this.infinitelyOften() + " F: " + this.eventually();
    }
}

