/*
 * Decompiled with CFR 0.152.
 */
package owl.translations;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jhoafparser.parser.generated.ParseException;
import owl.automaton.Automaton;
import owl.automaton.hoa.HoaReader;
import owl.bdd.FactorySupplier;
import owl.ltl.LabelledFormula;
import owl.ltl.visitors.PrintVisitor;

public class ExternalTranslator
implements Function<LabelledFormula, Automaton<Integer, ?>> {
    private static final Logger logger = Logger.getLogger(ExternalTranslator.class.getName());
    private static final Pattern splitPattern = Pattern.compile("\\s+");
    private final List<String> command;
    private final InputMode inputMode;

    public ExternalTranslator(String command, InputMode inputMode) {
        this(List.of(splitPattern.split(command)), inputMode);
    }

    public ExternalTranslator(List<String> command, InputMode inputMode) {
        this.inputMode = inputMode;
        this.command = List.copyOf(command);
        if (inputMode == InputMode.REPLACE) {
            Preconditions.checkArgument((boolean)this.command.contains("%f"));
        }
    }

    @Override
    public Automaton<Integer, ?> apply(LabelledFormula formula) {
        ProcessBuilder processBuilder;
        String formulaString = PrintVisitor.toString(formula, true);
        if (this.inputMode == InputMode.REPLACE) {
            ArrayList<String> adjustedCommand = new ArrayList<String>(this.command);
            adjustedCommand.replaceAll(x -> "%f".equals(x) ? formulaString : x);
            processBuilder = new ProcessBuilder(adjustedCommand);
        } else {
            processBuilder = new ProcessBuilder(this.command);
        }
        Process process = null;
        try {
            Automaton<Integer, ?> automaton;
            process = processBuilder.start();
            logger.log(Level.FINER, "Running process {0}", processBuilder.command());
            if (this.inputMode == InputMode.STDIN) {
                try (OutputStreamWriter outputStream = new OutputStreamWriter(process.getOutputStream(), Charset.defaultCharset());){
                    logger.log(Level.FINER, "Passing {0} to process", formulaString);
                    outputStream.write(formulaString);
                    ((Writer)outputStream).write(10);
                }
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));
            try {
                automaton = HoaReader.read(reader, FactorySupplier.defaultSupplier()::getBddSetFactory, formula.atomicPropositions());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchElementException | ParseException ex) {
                    throw new CompletionException("Exception occurred while using external translator.", ex);
                }
            }
            ((Reader)reader).close();
            return automaton;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
                try {
                    process.waitFor(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
                process.destroyForcibly();
            }
        }
    }

    public static enum InputMode {
        STDIN,
        REPLACE;

    }
}

