/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.delag;

import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.EmptyAutomaton;
import owl.automaton.SingletonAutomaton;
import owl.automaton.Views;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.edge.Edge;
import owl.bdd.FactorySupplier;
import owl.logic.propositional.PropositionalFormula;
import owl.ltl.BooleanConstant;
import owl.ltl.LabelledFormula;
import owl.translations.delag.DependencyTree;
import owl.translations.delag.DependencyTreeFactory;
import owl.translations.delag.History;
import owl.translations.delag.ProductState;
import owl.translations.delag.State;

public class DelagBuilder
implements Function<LabelledFormula, Automaton<State<Integer>, ? extends EmersonLeiAcceptance>> {
    private final Function<? super LabelledFormula, ? extends Automaton<?, ?>> fallback;

    public DelagBuilder(Function<? super LabelledFormula, ? extends Automaton<?, ?>> fallback) {
        this.fallback = fallback;
    }

    @Override
    public Automaton<State<Integer>, EmersonLeiAcceptance> apply(LabelledFormula inputFormula) {
        LabelledFormula formula = inputFormula.nnf();
        List<String> atomicPropositions = List.copyOf(formula.atomicPropositions());
        if (formula.formula().equals(BooleanConstant.FALSE)) {
            return EmptyAutomaton.of(atomicPropositions, EmersonLeiAcceptance.of(PropositionalFormula.falseConstant()));
        }
        if (formula.formula().equals(BooleanConstant.TRUE)) {
            return SingletonAutomaton.of(atomicPropositions, new State(), AllAcceptance.INSTANCE, Set.of());
        }
        DependencyTreeFactory treeConverter = new DependencyTreeFactory(FactorySupplier.defaultSupplier().getEquivalenceClassFactory(atomicPropositions), x -> Views.dropStateLabels(this.fallback.apply((LabelledFormula)x)));
        final DependencyTree tree = (DependencyTree)formula.formula().accept(treeConverter);
        PropositionalFormula<Integer> expression = tree.getAcceptanceExpression();
        ProductState initialProduct = treeConverter.buildInitialState();
        State initialState = new State(initialProduct, History.stepHistory(null, new BitSet(), History.create(tree.getRequiredHistory(initialProduct))));
        return new AbstractMemoizingAutomaton.EdgeImplementation<State<Integer>, EmersonLeiAcceptance>(atomicPropositions, Set.of(initialState), EmersonLeiAcceptance.of(expression)){
            private final Map<ProductState<?>, History> requiredHistory;
            {
                super(atomicPropositions, initialStates, acceptance);
                this.requiredHistory = new HashMap();
            }

            @Override
            public Edge<State<Integer>> edgeImpl(State<Integer> state, BitSet valuation) {
                ProductState.Builder builder = ProductState.builder();
                Boolean acc = tree.buildSuccessor(state, valuation, builder);
                if (acc != null && !acc.booleanValue()) {
                    return null;
                }
                ProductState successor = builder.build();
                History history = History.stepHistory(state.past, valuation, this.requiredHistory.computeIfAbsent(successor, x -> History.create(tree.getRequiredHistory(successor))));
                BitSet acceptance = tree.getAcceptance(state, valuation, acc);
                if (((EmersonLeiAcceptance)this.acceptance()).acceptanceSets() <= acceptance.length()) {
                    acceptance.clear(((EmersonLeiAcceptance)this.acceptance()).acceptanceSets(), acceptance.length());
                }
                return Edge.of(new State(successor, history), acceptance);
            }
        };
    }
}

