/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.delag;

import com.google.common.collect.Iterables;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.edge.Edge;
import owl.collections.BitSet2;
import owl.logic.propositional.PropositionalFormula;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.visitors.XDepthVisitor;
import owl.translations.delag.ProductState;
import owl.translations.delag.RequiredHistory;
import owl.translations.delag.SatisfactionRelation;
import owl.translations.delag.State;

abstract class DependencyTree<T> {
    DependencyTree() {
    }

    static <T> DependencyTree<T> createAnd(List<DependencyTree<T>> children) {
        if (children.size() == 1) {
            return (DependencyTree)Iterables.getOnlyElement(children);
        }
        return new And<T>(children);
    }

    static <T> Leaf<T> createLeaf(Formula formula, @Nonnegative int acceptanceSet, Supplier<Automaton<T, ?>> fallback, @Nullable PropositionalFormula<Integer> piggyback) {
        Automaton<T, Object> fallbackAutomaton;
        if (SyntacticFragments.isCoSafety(formula)) {
            if (piggyback == null) {
                return new Leaf(formula, Type.CO_SAFETY, acceptanceSet);
            }
            return new Leaf(formula, Type.CO_SAFETY, piggyback);
        }
        if (SyntacticFragments.isSafety(formula)) {
            if (piggyback == null) {
                return new Leaf(formula, Type.SAFETY, acceptanceSet);
            }
            return new Leaf(formula, Type.SAFETY, piggyback);
        }
        if (SyntacticFragment.FGX.contains(formula)) {
            if (SyntacticFragments.isAlmostAll(formula)) {
                return new Leaf(formula, Type.LIMIT_FG, acceptanceSet);
            }
            if (SyntacticFragments.isInfinitelyOften(formula)) {
                return new Leaf(formula, Type.LIMIT_GF, acceptanceSet);
            }
        }
        if ((fallbackAutomaton = fallback.get()).acceptance() instanceof AllAcceptance) {
            fallbackAutomaton = OmegaAcceptanceCast.cast(fallbackAutomaton, BuchiAcceptance.class);
        }
        return new FallbackLeaf<T>(formula, acceptanceSet, fallbackAutomaton);
    }

    static <T> DependencyTree<T> createOr(List<DependencyTree<T>> children) {
        if (children.size() == 1) {
            return (DependencyTree)Iterables.getOnlyElement(children);
        }
        return new Or<T>(children);
    }

    static long[] unionTail(long[] history1, long[] history2) {
        if (history1.length < history2.length) {
            return DependencyTree.unionTail(history2, history1);
        }
        int offset = history1.length - history2.length;
        for (int i = history2.length - 1; 0 <= i; --i) {
            int n = offset + i;
            history1[n] = history1[n] | history2[i];
        }
        return history1;
    }

    static Formula unwrap(Formula formula) {
        return ((Formula.UnaryTemporalOperator)((Formula.UnaryTemporalOperator)formula).operand()).operand();
    }

    @Nullable
    abstract Boolean buildSuccessor(State<T> var1, BitSet var2, ProductState.Builder<T> var3);

    abstract BitSet getAcceptance(State<T> var1, BitSet var2, @Nullable Boolean var3);

    abstract PropositionalFormula<Integer> getAcceptanceExpression();

    abstract long[] getRequiredHistory(ProductState<T> var1);

    static class Or<T>
    extends Node<T> {
        Or(List<DependencyTree<T>> children) {
            super(children);
        }

        @Override
        PropositionalFormula<Integer> getAcceptanceExpression() {
            return PropositionalFormula.Disjunction.of(this.getAcceptanceExpressionList());
        }

        @Override
        boolean shortCircuit(boolean value) {
            return value;
        }

        @Override
        boolean suspend(ProductState<T> productState, Leaf<T> leaf) {
            return productState.safety().containsKey(leaf.formula) && (SyntacticFragments.isFinite(leaf.formula) || leaf.type == Type.SAFETY);
        }

        public String toString() {
            if (this.children.isEmpty()) {
                return "ff";
            }
            return String.join((CharSequence)" | ", () -> this.children.stream().map(child -> child.toString()).iterator());
        }
    }

    static abstract class Node<T>
    extends DependencyTree<T> {
        final List<DependencyTree<T>> children;

        Node(List<DependencyTree<T>> children) {
            this.children = List.copyOf(children);
        }

        @Override
        Boolean buildSuccessor(State<T> state, BitSet valuation, ProductState.Builder<T> builder) {
            if (state.productState.finished().containsKey(this)) {
                builder.addFinished(this, state.productState.finished().get(this));
                return state.productState.finished().get(this);
            }
            ProductState.Builder childBuilder = new ProductState.Builder();
            Optional<Object> consensus = null;
            for (DependencyTree<T> child : this.children) {
                Boolean result = child.buildSuccessor(state, valuation, childBuilder);
                if (result != null && this.shortCircuit(result)) {
                    builder.addFinished(this, result);
                    return result;
                }
                if (result == null) {
                    consensus = Optional.empty();
                    continue;
                }
                if (consensus == null) {
                    consensus = Optional.of(result);
                    continue;
                }
                if (!consensus.isPresent()) continue;
                consensus = ((Boolean)consensus.get()).equals(result) ? consensus : Optional.empty();
            }
            assert (consensus != null) : "Children list was empty!";
            if (consensus.isPresent()) {
                builder.addFinished(this, (Boolean)consensus.get());
                return (Boolean)consensus.get();
            }
            builder.merge(childBuilder);
            return null;
        }

        @Override
        BitSet getAcceptance(State<T> state, BitSet valuation, @Nullable Boolean parentAcceptance) {
            Boolean acceptance = parentAcceptance == null ? state.productState.finished().get(this) : parentAcceptance;
            BitSet set = new BitSet();
            BitSet fairnessSet = new BitSet();
            for (DependencyTree<T> child : this.children) {
                if (child instanceof Leaf) {
                    if (this.suspend(state.productState, (Leaf)child)) {
                        fairnessSet = null;
                    }
                    if (fairnessSet != null && (((Leaf)child).type == Type.LIMIT_FG || ((Leaf)child).type == Type.LIMIT_GF)) {
                        fairnessSet.or(child.getAcceptance(state, valuation, acceptance));
                    }
                    if (((Leaf)child).type != Type.SAFETY && ((Leaf)child).type != Type.CO_SAFETY && ((Leaf)child).type != Type.FALLBACK) continue;
                    set.or(child.getAcceptance(state, valuation, acceptance));
                    continue;
                }
                set.or(child.getAcceptance(state, valuation, acceptance));
            }
            if (fairnessSet != null) {
                set.or(fairnessSet);
            }
            return set;
        }

        List<PropositionalFormula<Integer>> getAcceptanceExpressionList() {
            return this.children.stream().map(DependencyTree::getAcceptanceExpression).distinct().collect(Collectors.toList());
        }

        @Override
        long[] getRequiredHistory(ProductState<T> successor) {
            long[] requiredHistory = new long[]{};
            if (successor.finished().containsKey(this)) {
                return requiredHistory;
            }
            for (DependencyTree<T> child : this.children) {
                if (child instanceof Leaf && this.suspend(successor, (Leaf)child)) {
                    return new long[0];
                }
                requiredHistory = Node.unionTail(requiredHistory, child.getRequiredHistory(successor));
            }
            return requiredHistory;
        }

        abstract boolean shortCircuit(boolean var1);

        abstract boolean suspend(ProductState<T> var1, Leaf<T> var2);
    }

    static class Leaf<T>
    extends DependencyTree<T> {
        final PropositionalFormula<Integer> acceptance;
        final Formula formula;
        final Type type;

        Leaf(Formula formula, Type type, int acceptanceSet) {
            this.formula = formula;
            this.type = type;
            this.acceptance = type == Type.LIMIT_GF || type == Type.SAFETY ? PropositionalFormula.Variable.of(acceptanceSet) : PropositionalFormula.Negation.of(PropositionalFormula.Variable.of(acceptanceSet));
        }

        Leaf(Formula formula, Type type, PropositionalFormula<Integer> piggyback) {
            assert (type == Type.CO_SAFETY || type == Type.SAFETY);
            this.formula = formula;
            this.type = type;
            this.acceptance = piggyback;
        }

        @Override
        Boolean buildSuccessor(State<T> state, BitSet valuation, ProductState.Builder<T> builder) {
            Boolean value = state.productState.finished().get(this);
            if (value != null) {
                builder.addFinished(this, value);
                return value;
            }
            if (this.type == Type.SAFETY || this.type == Type.CO_SAFETY) {
                EquivalenceClass successor = state.productState.safety().get(this.formula).temporalStep(valuation).unfold();
                if (successor.isFalse()) {
                    builder.addFinished(this, Boolean.FALSE);
                    return Boolean.FALSE;
                }
                if (successor.isTrue()) {
                    builder.addFinished(this, Boolean.TRUE);
                    return Boolean.TRUE;
                }
                builder.addSafety(this.formula, successor);
                return null;
            }
            return null;
        }

        @Override
        BitSet getAcceptance(State<T> state, BitSet valuation, @Nullable Boolean parentAcceptance) {
            BitSet set = new BitSet();
            boolean inSet = false;
            switch (this.type) {
                case CO_SAFETY: {
                    if (!this.isFin()) break;
                    Boolean value = state.productState.finished().get(this);
                    inSet = value == null || value == false;
                    break;
                }
                case SAFETY: {
                    if (!this.isInf()) break;
                    Boolean value = state.productState.finished().get(this);
                    inSet = value == null || value != false;
                    break;
                }
                case LIMIT_GF: {
                    Formula unwrapped = Leaf.unwrap(this.formula);
                    inSet = SatisfactionRelation.models(state.past, valuation, unwrapped);
                    break;
                }
                case LIMIT_FG: {
                    Formula unwrapped = Leaf.unwrap(this.formula);
                    inSet = !SatisfactionRelation.models(state.past, valuation, unwrapped);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (parentAcceptance != null) {
                if (this.isInf()) {
                    inSet = parentAcceptance;
                } else {
                    boolean bl = inSet = parentAcceptance == false;
                }
            }
            if (inSet) {
                set.set(this.getAcceptanceSet());
            }
            return set;
        }

        @Override
        PropositionalFormula<Integer> getAcceptanceExpression() {
            return this.acceptance;
        }

        private boolean isInf() {
            return this.acceptance instanceof PropositionalFormula.Variable;
        }

        private boolean isFin() {
            return this.acceptance instanceof PropositionalFormula.Negation;
        }

        private int getAcceptanceSet() {
            if (this.acceptance instanceof PropositionalFormula.Variable) {
                return (Integer)((PropositionalFormula.Variable)this.acceptance).variable;
            }
            return (Integer)((PropositionalFormula.Variable)((PropositionalFormula.Negation)this.acceptance).operand).variable;
        }

        @Override
        long[] getRequiredHistory(ProductState<T> successor) {
            if (this.type == Type.CO_SAFETY || this.type == Type.SAFETY || XDepthVisitor.getDepth(this.formula) == 0) {
                return new long[0];
            }
            return RequiredHistory.getRequiredHistory(Leaf.unwrap(this.formula));
        }
    }

    static class FallbackLeaf<T>
    extends Leaf<T> {
        final int acceptanceSet;
        final Automaton<T, ?> automaton;

        FallbackLeaf(Formula formula, int acceptanceSet, Automaton<T, ?> automaton) {
            super(formula, Type.FALLBACK, -1);
            assert (automaton.is(Automaton.Property.DETERMINISTIC));
            this.acceptanceSet = acceptanceSet;
            this.automaton = automaton;
        }

        BitSet crop(BitSet valuation) {
            int apSize = this.automaton.atomicPropositions().size();
            if (valuation.length() <= apSize) {
                return valuation;
            }
            BitSet valuationCopy = BitSet2.copyOf(valuation);
            valuationCopy.clear(apSize, valuation.length());
            return valuationCopy;
        }

        @Override
        Boolean buildSuccessor(State<T> state, BitSet valuation, ProductState.Builder<T> builder) {
            Edge<T> edge;
            Object fallbackState = state.productState.fallback().get(this.formula);
            Edge<T> edge2 = edge = fallbackState == null ? null : this.automaton.edge(fallbackState, this.crop(valuation));
            if (edge == null) {
                builder.addFinished(this, Boolean.FALSE);
                return Boolean.FALSE;
            }
            builder.addFallback(this.formula, edge.successor());
            return null;
        }

        @Override
        BitSet getAcceptance(State<T> state, BitSet valuation, @Nullable Boolean parentAcceptance) {
            Object fallbackState = state.productState.fallback().get(this.formula);
            Edge<T> edge = fallbackState == null ? null : this.automaton.edge(fallbackState, this.crop(valuation));
            PrimitiveIterator.OfInt acceptanceSets = edge == null ? ((EmersonLeiAcceptance)this.automaton.acceptance()).rejectingSet().orElseThrow().intIterator() : edge.colours().intIterator();
            BitSet set = new BitSet();
            acceptanceSets.forEachRemaining(x -> set.set(x + this.acceptanceSet));
            return set;
        }

        @Override
        PropositionalFormula<Integer> getAcceptanceExpression() {
            return this.shift(((EmersonLeiAcceptance)this.automaton.acceptance()).booleanExpression());
        }

        @Override
        long[] getRequiredHistory(ProductState<T> successor) {
            return new long[0];
        }

        private PropositionalFormula<Integer> shift(PropositionalFormula<Integer> expression) {
            return expression.map(i -> i + this.acceptanceSet);
        }

        public String toString() {
            return String.format("Fallback{%s, %s %d}", LabelledFormula.of(this.formula, this.automaton.atomicPropositions()), this.acceptance, this.acceptanceSet);
        }
    }

    static class And<T>
    extends Node<T> {
        And(List<DependencyTree<T>> children) {
            super(children);
        }

        @Override
        PropositionalFormula<Integer> getAcceptanceExpression() {
            return PropositionalFormula.Conjunction.of(this.getAcceptanceExpressionList());
        }

        @Override
        boolean shortCircuit(boolean value) {
            return !value;
        }

        @Override
        boolean suspend(ProductState<T> productState, Leaf<T> leaf) {
            return productState.safety().containsKey(leaf.formula) && (SyntacticFragments.isFinite(leaf.formula) || leaf.type == Type.CO_SAFETY);
        }

        public String toString() {
            if (this.children.isEmpty()) {
                return "tt";
            }
            return String.join((CharSequence)" & ", () -> this.children.stream().map(child -> child.toString()).iterator());
        }
    }

    static enum Type {
        SAFETY,
        CO_SAFETY,
        LIMIT_FG,
        LIMIT_GF,
        FALLBACK;

    }
}

