/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dela;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.tum.in.jbdd.Bdd;
import de.tum.in.jbdd.BddConfiguration;
import de.tum.in.jbdd.BddFactory;
import de.tum.in.jbdd.ImmutableBddConfiguration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import owl.logic.propositional.PropositionalFormula;

public final class PropositionalFormulaHelper {
    private PropositionalFormulaHelper() {
    }

    @Nullable
    public static <K> Map<K, Boolean> findPartialAssignment(PropositionalFormula<K> formula, PropositionalFormula<K> refinedFormula) {
        HashSet<K> formulaVariables = new HashSet<K>(formula.variables());
        HashSet<K> refinedFormulaVariables = new HashSet<K>(refinedFormula.variables());
        Preconditions.checkArgument((boolean)formulaVariables.containsAll(refinedFormulaVariables));
        HashBiMap variableMap = HashBiMap.create();
        HashMap partialAssignment = new HashMap();
        int stoppingVariable = 0;
        for (Object variable : formulaVariables) {
            if (refinedFormulaVariables.contains(variable)) continue;
            partialAssignment.put(variable, null);
            variableMap.put(variable, (Object)variableMap.size());
        }
        stoppingVariable = partialAssignment.size();
        for (Object variable : refinedFormulaVariables) {
            variableMap.put(variable, (Object)variableMap.size());
        }
        Bdd bdd = BddFactory.buildBddRecursive((int)1000, (BddConfiguration)ImmutableBddConfiguration.builder().build());
        bdd.createVariables(variableMap.size() + 1);
        int formulaNode = PropositionalFormulaHelper.translateBdd(formula, bdd, variableMap);
        int refinedFormulaNode = PropositionalFormulaHelper.translateBdd(refinedFormula, bdd, variableMap);
        return PropositionalFormulaHelper.findPartialAssignment(formulaNode, refinedFormulaNode, bdd, variableMap, stoppingVariable).orElse(null);
    }

    private static <K> Optional<Map<K, Boolean>> findPartialAssignment(int formulaNode, int refinedFormulaNode, Bdd bdd, BiMap<K, Integer> variableMapping, int stoppingValue) {
        int variable;
        int n = variable = bdd.isNodeRoot(formulaNode) ? Integer.MAX_VALUE : bdd.variable(formulaNode);
        if (variable < stoppingValue) {
            Optional<Map<K, Boolean>> low = PropositionalFormulaHelper.findPartialAssignment(bdd.low(formulaNode), refinedFormulaNode, bdd, variableMapping, stoppingValue);
            if (low.isPresent()) {
                low.get().put(variableMapping.inverse().get((Object)variable), Boolean.FALSE);
                return low;
            }
            Optional<Map<K, Boolean>> high = PropositionalFormulaHelper.findPartialAssignment(bdd.high(formulaNode), refinedFormulaNode, bdd, variableMapping, stoppingValue);
            if (high.isPresent()) {
                high.get().put(variableMapping.inverse().get((Object)variable), Boolean.TRUE);
            }
            return high;
        }
        return formulaNode == refinedFormulaNode ? Optional.of(new HashMap()) : Optional.empty();
    }

    private static <K> int translateBdd(PropositionalFormula<K> formula, Bdd bdd, Map<K, Integer> variableMapping) {
        if (formula instanceof PropositionalFormula.Variable) {
            return bdd.variableNode(variableMapping.get(((PropositionalFormula.Variable)formula).variable).intValue());
        }
        if (formula instanceof PropositionalFormula.Negation) {
            return bdd.reference(bdd.not(PropositionalFormulaHelper.translateBdd(((PropositionalFormula.Negation)formula).operand, bdd, variableMapping)));
        }
        if (formula instanceof PropositionalFormula.Biconditional) {
            return bdd.reference(bdd.equivalence(PropositionalFormulaHelper.translateBdd(((PropositionalFormula.Biconditional)formula).leftOperand, bdd, variableMapping), PropositionalFormulaHelper.translateBdd(((PropositionalFormula.Biconditional)formula).rightOperand, bdd, variableMapping)));
        }
        if (formula instanceof PropositionalFormula.Conjunction) {
            int x = bdd.trueNode();
            for (PropositionalFormula conjunct : ((PropositionalFormula.Conjunction)formula).conjuncts) {
                int y = PropositionalFormulaHelper.translateBdd(conjunct, bdd, variableMapping);
                x = bdd.consume(bdd.and(x, y), x, y);
            }
            return x;
        }
        assert (formula instanceof PropositionalFormula.Disjunction);
        int x = bdd.falseNode();
        for (PropositionalFormula disjunct : ((PropositionalFormula.Disjunction)formula).disjuncts) {
            int y = PropositionalFormulaHelper.translateBdd(disjunct, bdd, variableMapping);
            x = bdd.consume(bdd.or(x, y), x, y);
        }
        return x;
    }
}

