/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2dpa;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.EmptyAutomaton;
import owl.automaton.SingletonAutomaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.ltl.EquivalenceClass;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragments;
import owl.translations.ltl2dpa.SymmetricRankingState;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.SymmetricLDBAConstruction;
import owl.translations.ltl2ldba.SymmetricProductState;
import owl.translations.mastertheorem.SymmetricEvaluatedFixpoints;

final class SymmetricDPAConstruction {
    private static final SymmetricLDBAConstruction<BuchiAcceptance> LDBA_CONSTRUCTION = SymmetricLDBAConstruction.of(BuchiAcceptance.class);

    SymmetricDPAConstruction() {
    }

    Automaton<SymmetricRankingState, ParityAcceptance> of(LabelledFormula labelledFormula, boolean complete) {
        AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, BuchiAcceptance, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> ldba = LDBA_CONSTRUCTION.apply(labelledFormula);
        List<String> atomicPropositions = ldba.acceptingComponent().atomicPropositions();
        if (ldba.initialComponent().initialStates().isEmpty()) {
            ParityAcceptance acceptance = new ParityAcceptance(3, ParityAcceptance.Parity.MIN_ODD);
            return complete ? SingletonAutomaton.of(atomicPropositions, SymmetricRankingState.of(Map.of()), acceptance, acceptance.rejectingSet().orElseThrow()) : EmptyAutomaton.of(atomicPropositions, acceptance);
        }
        final Builder builder = new Builder(ldba, complete);
        return new AbstractMemoizingAutomaton.EdgeImplementation<SymmetricRankingState, ParityAcceptance>(atomicPropositions, builder.ldba.factory(), Set.of(builder.initialState), builder.acceptance){
            @Nullable
            private Builder internalBuilder;
            {
                super(atomicPropositions, factory, initialStates, acceptance);
                this.internalBuilder = builder;
            }

            @Override
            protected Edge<SymmetricRankingState> edgeImpl(SymmetricRankingState state, BitSet valuation) {
                return this.internalBuilder.edge(state, valuation);
            }

            @Override
            protected void explorationCompleted() {
                this.internalBuilder = null;
            }
        };
    }

    private static Map.Entry<Integer, SymmetricEvaluatedFixpoints> fixpointsEntry(Map.Entry<Integer, SymmetricProductState> stateEntry) {
        return Map.entry(stateEntry.getKey(), stateEntry.getValue().evaluatedFixpoints);
    }

    private static final class Builder {
        private final ParityAcceptance acceptance;
        private final SymmetricRankingState initialState;
        private final List<Set<Map<Integer, EquivalenceClass>>> initialComponentSccs;
        private final AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, BuchiAcceptance, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> ldba;
        @Nullable
        private final Edge<SymmetricRankingState> rejectingEdge;

        private Builder(AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, BuchiAcceptance, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> ldba, boolean complete) {
            this.ldba = ldba;
            this.initialComponentSccs = SccDecomposition.of(ldba.initialComponent()).sccs();
            this.acceptance = new ParityAcceptance(2 * (ldba.acceptingComponent().states().size() + 1), ParityAcceptance.Parity.MIN_ODD);
            Map<Integer, EquivalenceClass> ldbaInitialState = ldba.initialComponent().initialState();
            this.initialState = this.edge(ldbaInitialState, List.of(), 0, -1, null).successor();
            this.rejectingEdge = complete ? Edge.of(SymmetricRankingState.of(Map.of()), this.acceptance.rejectingSet().orElseThrow()) : null;
        }

        private Edge<SymmetricRankingState> edge(Map<Integer, EquivalenceClass> successor, List<Map.Entry<Integer, SymmetricProductState>> previousRanking, int previousSafetyBucket, int previousSafetyBucketIndex, @Nullable BitSet valuation) {
            int safetyBucketIndex;
            int safetyBucket;
            for (EquivalenceClass clazz : successor.values()) {
                if (!SyntacticFragments.isSafety(clazz)) continue;
                return Edge.of(SymmetricRankingState.of(successor), 1);
            }
            HashSet allowedComponents = new HashSet();
            List targets = List.of(new ArrayList(), new ArrayList(), new ArrayList());
            TreeMap safety = new TreeMap();
            successor.forEach((index, value) -> {
                for (SymmetricProductState jumpTarget : this.ldba.stateAnnotation().apply((Integer)index, (EquivalenceClass)value)) {
                    if (!this.ldba.acceptingComponent().states().contains(jumpTarget)) continue;
                    SymmetricEvaluatedFixpoints fixpoints = jumpTarget.evaluatedFixpoints;
                    boolean changed = allowedComponents.add(Map.entry(index, fixpoints));
                    if (fixpoints.isSafety()) {
                        safety.compute((Integer)index, (x, oldList) -> {
                            if (oldList == null) {
                                return new ArrayList<SymmetricProductState>(List.of(jumpTarget));
                            }
                            oldList.add(jumpTarget);
                            return oldList;
                        });
                        continue;
                    }
                    if (fixpoints.isLiveness() && jumpTarget.safety.isTrue()) {
                        assert (changed);
                        ((List)targets.get(0)).add(Map.entry(index, jumpTarget));
                        continue;
                    }
                    if (fixpoints.isLiveness()) {
                        assert (changed);
                        ((List)targets.get(1)).add(Map.entry(index, jumpTarget));
                        continue;
                    }
                    assert (changed);
                    ((List)targets.get(2)).add(Map.entry(index, jumpTarget));
                }
            });
            Comparator<Map.Entry> comparator = Comparator.comparingInt(Map.Entry::getKey).thenComparing(y -> ((SymmetricProductState)y.getValue()).evaluatedFixpoints);
            targets.forEach(target -> target.sort(comparator));
            safety.values().forEach(x -> x.sort(Comparator.comparing(y -> y.evaluatedFixpoints)));
            int edgeColor = 2 * previousRanking.size();
            ArrayList<Map.Entry<Integer, SymmetricProductState>> ranking = new ArrayList<Map.Entry<Integer, SymmetricProductState>>(previousRanking.size());
            boolean activeSafetyComponent = false;
            ListIterator<Map.Entry<Integer, SymmetricProductState>> iterator = previousRanking.listIterator();
            while (iterator.hasNext()) {
                SymmetricProductState rankingSuccessor;
                assert (valuation != null) : "Valuation is only allowed to be null for empty rankings.";
                Map.Entry<Integer, SymmetricProductState> entry = iterator.next();
                Edge<SymmetricProductState> rankingEdge = this.ldba.acceptingComponent().edge(entry.getValue(), valuation);
                SymmetricProductState symmetricProductState = rankingSuccessor = rankingEdge == null ? null : (SymmetricProductState)rankingEdge.successor();
                if (rankingEdge == null || !allowedComponents.remove(SymmetricDPAConstruction.fixpointsEntry(entry))) {
                    edgeColor = Math.min(2 * iterator.previousIndex(), edgeColor);
                    continue;
                }
                ranking.add(Map.entry(entry.getKey(), rankingSuccessor));
                if (rankingEdge.colours().contains(0)) {
                    edgeColor = Math.min(2 * iterator.previousIndex() + 1, edgeColor);
                }
                if (!rankingSuccessor.evaluatedFixpoints.isSafety()) continue;
                activeSafetyComponent = true;
            }
            if (activeSafetyComponent) {
                safetyBucket = previousSafetyBucket;
                safetyBucketIndex = previousSafetyBucketIndex;
            } else {
                for (Map.Entry rankingState : Iterables.concat((Iterable)targets.get(0), (Iterable)targets.get(1), (Iterable)targets.get(2))) {
                    if (!allowedComponents.remove(SymmetricDPAConstruction.fixpointsEntry(rankingState))) continue;
                    ranking.add(rankingState);
                }
                Map.Entry safetyEntry = safety.ceilingEntry(previousSafetyBucket);
                safetyBucketIndex = previousSafetyBucketIndex;
                if (safetyEntry != null) {
                    if (safetyEntry.getKey() == previousSafetyBucket && ((List)safetyEntry.getValue()).size() <= safetyBucketIndex + 1) {
                        safetyEntry = safety.ceilingEntry(previousSafetyBucket + 1);
                        safetyBucketIndex = -1;
                    } else if (safetyEntry.getKey() > previousSafetyBucket) {
                        safetyBucketIndex = -1;
                    }
                }
                if (safetyEntry == null) {
                    safetyEntry = safety.ceilingEntry(0);
                    safetyBucketIndex = -1;
                }
                if (safetyEntry == null) {
                    safetyBucket = 0;
                    safetyBucketIndex = -1;
                } else {
                    safetyBucket = safetyEntry.getKey();
                    assert (safetyBucket > 0);
                    ranking.add(Map.entry(safetyBucket, (SymmetricProductState)((List)safetyEntry.getValue()).get(++safetyBucketIndex)));
                }
            }
            assert (edgeColor < this.acceptance.acceptanceSets());
            return Edge.of(SymmetricRankingState.of(successor, ranking, safetyBucket, safetyBucketIndex), edgeColor);
        }

        @Nullable
        Edge<SymmetricRankingState> edge(SymmetricRankingState state, BitSet valuation) {
            if (this.rejectingEdge != null && this.rejectingEdge.successor().equals(state)) {
                return this.rejectingEdge;
            }
            Map<Integer, EquivalenceClass> successor = this.ldba.initialComponent().successor((Map<Integer, EquivalenceClass>)state.state(), valuation);
            if (successor == null) {
                return this.rejectingEdge;
            }
            if (this.initialComponentSccs.stream().anyMatch(x -> x.contains(state.state()) && !x.contains(successor))) {
                return this.edge(successor, List.of(), 0, -1, valuation).withoutAcceptance();
            }
            return this.edge(successor, state.ranking(), state.safetyBucket(), state.safetyBucketIndex(), valuation);
        }
    }
}

