/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.edge.Edge;
import owl.bdd.Factories;
import owl.bdd.FactorySupplier;
import owl.bdd.MtBdd;
import owl.bdd.MtBddOperations;
import owl.collections.Collections3;
import owl.collections.Either;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragments;
import owl.ltl.XOperator;
import owl.ltl.rewriter.NormalForms;
import owl.translations.BlockingElements;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.canonical.RoundRobinState;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.SymmetricProductState;
import owl.translations.mastertheorem.Fixpoints;
import owl.translations.mastertheorem.Predicates;
import owl.translations.mastertheorem.Rewriter;
import owl.translations.mastertheorem.Selector;
import owl.translations.mastertheorem.SymmetricEvaluatedFixpoints;

public final class SymmetricLDBAConstruction<B extends GeneralizedBuchiAcceptance>
implements Function<LabelledFormula, AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, B, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>>> {
    private final Class<? extends B> acceptanceClass;

    private SymmetricLDBAConstruction(Class<? extends B> acceptanceClass) {
        this.acceptanceClass = acceptanceClass;
        assert (BuchiAcceptance.class.equals(acceptanceClass) || GeneralizedBuchiAcceptance.class.equals(acceptanceClass));
    }

    public static <B extends GeneralizedBuchiAcceptance> SymmetricLDBAConstruction<B> of(Class<? extends B> clazz) {
        return new SymmetricLDBAConstruction<B>(clazz);
    }

    @Override
    public AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, B, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> apply(LabelledFormula input) {
        LabelledFormula formula = input.nnf();
        Factories factories = FactorySupplier.defaultSupplier().getFactories(formula.atomicPropositions());
        ArrayList blockingCoSafetyOperators = new ArrayList();
        blockingCoSafetyOperators.add(Set.of());
        HashMap epsilonJumps = new HashMap();
        int acceptanceSets = 1;
        ArrayList<Set<Set<Fixpoints>>> knownFixpoints = new ArrayList<Set<Set<Fixpoints>>>(List.of(Set.of()));
        HashMap<Fixpoints, Set> evaluationMap = new HashMap<Fixpoints, Set>();
        HashMap<SymmetricEvaluatedFixpoints, SymmetricEvaluatedFixpoints.DeterministicAutomata> automataMap = new HashMap<SymmetricEvaluatedFixpoints, SymmetricEvaluatedFixpoints.DeterministicAutomata>();
        DeterministicConstructions.Tracking factory = new DeterministicConstructions.Tracking(factories);
        ArrayList initialFormulas = new ArrayList();
        Set<Formula> dnf = Collections3.transformSet(NormalForms.toDnf(formula.formula(), NormalForms.SYNTHETIC_CO_SAFETY_LITERAL), Conjunction::of);
        List<Set<Formula>> groupedDnf = Collections3.partition(dnf, SymmetricLDBAConstruction::groupInDnf);
        groupedDnf.forEach(x -> initialFormulas.add(Disjunction.of(x)));
        initialFormulas.sort(null);
        for (Formula formula2 : initialFormulas) {
            Set<Fixpoints> sets = Selector.selectSymmetric(formula2, false);
            knownFixpoints.add(sets);
            blockingCoSafetyOperators.add(BlockingElements.blockingCoSafetyFormulas(factories.eqFactory.of(formula2)));
            for (Fixpoints fixpoints : sets) {
                Fixpoints simplified = fixpoints.simplified();
                Set<SymmetricEvaluatedFixpoints> evaluatedSet = SymmetricEvaluatedFixpoints.build(formula2, simplified, factories);
                evaluationMap.merge(simplified, evaluatedSet, Sets::union);
                for (SymmetricEvaluatedFixpoints evaluated : evaluatedSet) {
                    if (automataMap.containsKey(evaluated)) continue;
                    SymmetricEvaluatedFixpoints.DeterministicAutomata deterministicAutomata = evaluated.deterministicAutomata(factories, this.acceptanceClass.equals(GeneralizedBuchiAcceptance.class));
                    automataMap.put(evaluated, deterministicAutomata);
                    if (deterministicAutomata.gfCoSafetyAutomaton == null) continue;
                    acceptanceSets = Math.max(acceptanceSets, ((GeneralizedBuchiAcceptance)deterministicAutomata.gfCoSafetyAutomaton.acceptance()).acceptanceSets());
                }
            }
        }
        Map<Integer, EquivalenceClass> initialState = new HashMap<Integer, EquivalenceClass>();
        for (int i = 0; i < initialFormulas.size(); ++i) {
            initialState.put(i + 1, factory.asInitialState((Formula)initialFormulas.get(i)));
        }
        initialState = SymmetricLDBAConstruction.canonicalState(initialState);
        AcceptingComponentBuilder acceptingComponentBuilder = new AcceptingComponentBuilder(this, factories, (GeneralizedBuchiAcceptance)this.acceptanceClass.cast(GeneralizedBuchiAcceptance.of(acceptanceSets)));
        BitSet accSets = new BitSet();
        accSets.set(0, acceptanceSets);
        final Function<Map, MtBdd> edgeTree = state -> {
            Map<Integer, MtBdd> successors = state.entrySet().stream().map(x -> Map.entry((Integer)x.getKey(), factory.successorTree((EquivalenceClass)x.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return MtBddOperations.cartesianProduct(successors).map(x -> {
                Map<Integer, EquivalenceClass> successor = SymmetricLDBAConstruction.canonicalState((Map)Iterables.getOnlyElement((Iterable)x, null));
                if (successor == null) {
                    return Set.of();
                }
                return Set.of(SymmetricLDBAConstruction.isAccepting(successor) ? Edge.of(successor, accSets) : Edge.of(successor));
            });
        };
        AbstractMemoizingAutomaton.EdgeTreeImplementation<Map<Integer, EquivalenceClass>, AllAcceptance> automaton = new AbstractMemoizingAutomaton.EdgeTreeImplementation<Map<Integer, EquivalenceClass>, AllAcceptance>(factories.eqFactory.atomicPropositions(), factories.vsFactory, Collections3.ofNullable(initialState), AllAcceptance.INSTANCE){

            @Override
            public MtBdd<Edge<Map<Integer, EquivalenceClass>>> edgeTreeImpl(Map<Integer, EquivalenceClass> state) {
                return (MtBdd)edgeTree.apply(state);
            }
        };
        Consumer<Map.Entry> consumer = entry -> {
            if (epsilonJumps.containsKey(entry)) {
                return;
            }
            EquivalenceClass clazz = (EquivalenceClass)entry.getValue();
            assert ((Integer)entry.getKey() != 0 || SyntacticFragments.isCoSafety(clazz) || SyntacticFragments.isSafety(clazz));
            if (!Collections.disjoint(clazz.temporalOperators(), (Collection)blockingCoSafetyOperators.get((Integer)entry.getKey())) || BlockingElements.isBlockedByTransient(clazz) || BlockingElements.isBlockedByCoSafety(clazz)) {
                epsilonJumps.put(entry, Set.of());
                return;
            }
            Set<Formula.TemporalOperator> nestedTemporalOperators = clazz.temporalOperators(true);
            Set availableFixpoints = ((Set)knownFixpoints.get((Integer)entry.getKey())).stream().filter(x -> x.allFixpointsPresent(nestedTemporalOperators)).map(Fixpoints::simplified).collect(Collectors.toSet());
            ArrayList<SymmetricProductState> jumps = new ArrayList<SymmetricProductState>();
            evaluationMap.forEach((fixpoints, set) -> {
                if (!availableFixpoints.contains(fixpoints)) {
                    return;
                }
                for (SymmetricEvaluatedFixpoints symmetricEvaluatedFixpoints : set) {
                    Set protectedXOperators;
                    EquivalenceClass remainder;
                    EquivalenceClass xRemovedRemainder = remainder = clazz.substitute(new Rewriter.ToSafety((Fixpoints)fixpoints)).unfold();
                    while (!(remainder = xRemovedRemainder).equals(xRemovedRemainder = remainder.substitute(arg_0 -> SymmetricLDBAConstruction.lambda$apply$7(protectedXOperators = remainder.support(false).stream().filter(x -> x instanceof Formula.TemporalOperator && !(x instanceof XOperator)).flatMap(x -> {
                        assert (Predicates.IS_FIXPOINT.test((Formula)x));
                        return x.subformulas(XOperator.class).stream();
                    }).collect(Collectors.toSet()), arg_0)))) {
                    }
                    if (remainder.isFalse()) continue;
                    SymmetricEvaluatedFixpoints.DeterministicAutomata deterministicAutomata = (SymmetricEvaluatedFixpoints.DeterministicAutomata)automataMap.get(symmetricEvaluatedFixpoints);
                    EquivalenceClass safety = deterministicAutomata.safetyAutomaton.onlyInitialStateWithRemainder(remainder);
                    if (safety.isFalse()) continue;
                    jumps.add(new SymmetricProductState(safety, deterministicAutomata.gfCoSafetyAutomaton == null ? null : (RoundRobinState)deterministicAutomata.gfCoSafetyAutomaton.initialState(), symmetricEvaluatedFixpoints, deterministicAutomata));
                }
            });
            jumps.sort(Comparator.comparing(x -> x.evaluatedFixpoints).reversed());
            epsilonJumps.put(entry, Set.copyOf(Collections3.maximalElements(jumps, (x1, y) -> {
                if (x1.isCoveredBy((SymmetricProductState)y) && y.isCoveredBy((SymmetricProductState)x1)) {
                    return false;
                }
                return x1.isCoveredBy((SymmetricProductState)y);
            })));
        };
        HashMapAutomaton<Map<Integer, EquivalenceClass>, AllAcceptance> initialComponent = HashMapAutomaton.copyOf(automaton);
        assert (initialComponent.is(Automaton.Property.DETERMINISTIC));
        initialComponent.states().forEach(x -> x.entrySet().forEach(jumpGenerator));
        return AnnotatedLDBA.build(initialComponent, acceptingComponentBuilder, state -> {
            if (SymmetricLDBAConstruction.isAccepting(state) || SymmetricLDBAConstruction.containsUnresolvedFinite(state)) {
                return Set.of();
            }
            HashSet jumps = new HashSet();
            state.entrySet().forEach(x -> jumps.addAll((Collection)epsilonJumps.get(x)));
            return jumps;
        }, x -> (EquivalenceClass)x.values().stream().reduce(EquivalenceClass::or).orElseThrow(), (SortedSet)evaluationMap.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(TreeSet::new)), (x, y) -> (Set)epsilonJumps.get(Map.entry(x, y)));
    }

    public MutableAutomaton<Either<Map<Integer, EquivalenceClass>, SymmetricProductState>, B> applyWithShortcuts(LabelledFormula formula) {
        MutableAutomaton<Either<Map<Integer, EquivalenceClass>, SymmetricProductState>, B> ldba = this.apply(formula).copyAsMutable();
        HashMap shortCuts = new HashMap();
        ldba.states().forEach(state -> {
            if (state.type() == Either.Type.LEFT) {
                return;
            }
            SymmetricProductState productState = (SymmetricProductState)state.right();
            if (productState.liveness == null) {
                shortCuts.put(productState.safety, productState);
            }
        });
        ldba.updateEdges((state, edge) -> {
            if (state.type() == Either.Type.RIGHT || ((Either)edge.successor()).type() == Either.Type.RIGHT) {
                return edge;
            }
            Map successor = (Map)((Either)edge.successor()).left();
            if (successor.size() != 1 || !successor.containsKey(0)) {
                return edge;
            }
            SymmetricProductState shortCut = (SymmetricProductState)shortCuts.get(successor.get(0));
            if (shortCut == null) {
                return edge;
            }
            return Edge.of(Either.right(shortCut));
        });
        ldba.trim();
        return ldba;
    }

    private static boolean containsUnresolvedFinite(Map<?, ? extends EquivalenceClass> state) {
        return state.values().stream().anyMatch(SymmetricLDBAConstruction::containsUnresolvedFinite);
    }

    private static boolean containsUnresolvedFinite(EquivalenceClass clazz) {
        if (clazz.temporalOperators().isEmpty()) {
            return true;
        }
        Set scopedXOperators = clazz.temporalOperators().stream().flatMap(x -> x.operands.stream().flatMap(y -> y.subformulas(XOperator.class).stream())).collect(Collectors.toSet());
        return clazz.temporalOperators().stream().anyMatch(x -> x instanceof XOperator && !scopedXOperators.contains(x));
    }

    private static boolean groupInDnf(Formula x, Formula y) {
        Set<Formula> ySubformulas;
        if (SyntacticFragments.isCoSafety(x) && SyntacticFragments.isCoSafety(y)) {
            return true;
        }
        Set<Formula> xSubformulas = x.subformulas(Predicates.IS_GREATEST_FIXPOINT);
        return !Collections.disjoint(xSubformulas, ySubformulas = y.subformulas(Predicates.IS_GREATEST_FIXPOINT));
    }

    @Nullable
    private static Map<Integer, EquivalenceClass> canonicalState(@Nullable Map<Integer, EquivalenceClass> state) {
        if (state == null) {
            return null;
        }
        HashMap<Integer, EquivalenceClass> canonicalState = new HashMap<Integer, EquivalenceClass>();
        HashSet coSafety = new HashSet();
        state.forEach((index, clazz) -> {
            if (SyntacticFragments.isCoSafety(clazz)) {
                coSafety.add(clazz);
            } else if (!canonicalState.containsValue(clazz)) {
                canonicalState.put((Integer)index, (EquivalenceClass)clazz);
            }
        });
        assert (!canonicalState.containsKey(0) || SyntacticFragments.isSafety((EquivalenceClass)canonicalState.get(0)) || SyntacticFragments.isCoSafety((EquivalenceClass)canonicalState.get(0)));
        EquivalenceClass coSafetyClass = coSafety.stream().reduce(EquivalenceClass::or).orElse(null);
        if (coSafetyClass != null) {
            if (coSafetyClass.isTrue()) {
                return Map.of(0, coSafetyClass);
            }
            if (!coSafetyClass.isFalse()) {
                canonicalState.put(0, coSafetyClass);
            }
        }
        if (canonicalState.isEmpty()) {
            return null;
        }
        if (canonicalState.values().stream().allMatch(SyntacticFragments::isSafety)) {
            EquivalenceClass clazz2 = (EquivalenceClass)canonicalState.values().stream().reduce(EquivalenceClass::or).orElseThrow();
            if (clazz2.isFalse()) {
                return null;
            }
            return Map.of(0, clazz2);
        }
        return Map.copyOf(canonicalState);
    }

    private static boolean isAccepting(Map<Integer, EquivalenceClass> state) {
        return state.values().stream().allMatch(SyntacticFragments::isSafety);
    }

    private static /* synthetic */ Formula lambda$apply$7(Set protectedXOperators, Formula.TemporalOperator x) {
        return x instanceof XOperator && !protectedXOperators.contains(x) ? BooleanConstant.FALSE : x;
    }

    private static class AcceptingComponentBuilder
    implements AnnotatedLDBA.AcceptingComponentBuilder<SymmetricProductState, B> {
        private final List<SymmetricProductState> anchors = new ArrayList<SymmetricProductState>();
        private final Factories factories;
        private final B acceptance;
        final /* synthetic */ SymmetricLDBAConstruction this$0;

        private AcceptingComponentBuilder(Factories factories, B acceptance) {
            this.this$0 = var1_1;
            this.factories = factories;
            this.acceptance = acceptance;
        }

        @Override
        public void addInitialStates(Collection<? extends SymmetricProductState> initialStates) {
            this.anchors.addAll(List.copyOf(initialStates));
        }

        protected MtBdd<Edge<SymmetricProductState>> edgeTree(SymmetricProductState state) {
            SymmetricEvaluatedFixpoints.DeterministicAutomata automata = Objects.requireNonNull(state.automata);
            EquivalenceClass safetyState = Objects.requireNonNull(state.safety);
            DeterministicConstructions.Safety safetyAutomaton = automata.safetyAutomaton;
            MtBdd<Edge<EquivalenceClass>> safetyEdgeTree = safetyAutomaton.edgeTree(safetyState);
            if (automata.gfCoSafetyAutomaton == null) {
                Function<Edge, Edge> mapper = safetyEdge -> {
                    SymmetricProductState successor = new SymmetricProductState((EquivalenceClass)safetyEdge.successor(), null, state.evaluatedFixpoints, automata);
                    BitSet acceptance = new BitSet();
                    acceptance.set(0, ((EmersonLeiAcceptance)this.acceptance).acceptanceSets());
                    return Edge.of(successor, acceptance);
                };
                return safetyEdgeTree.map(x -> x.stream().map(mapper).collect(Collectors.toUnmodifiableSet()));
            }
            RoundRobinState<EquivalenceClass> livenessState = Objects.requireNonNull(state.liveness);
            DeterministicConstructions.GfCoSafety livenessAutomaton = automata.gfCoSafetyAutomaton;
            MtBdd<Edge<RoundRobinState<EquivalenceClass>>> livenessEdgeTree = livenessAutomaton.edgeTree(livenessState);
            assert (safetyEdgeTree.flatValues().stream().allMatch(x -> x.colours().isEmpty()));
            assert (livenessEdgeTree.flatValues().stream().allMatch(x -> x.colours().last().orElse(-1) < ((EmersonLeiAcceptance)this.acceptance).acceptanceSets()));
            return MtBddOperations.cartesianProduct(safetyEdgeTree, livenessEdgeTree, (safetyEdge, livenessEdge) -> {
                SymmetricProductState successor = new SymmetricProductState((EquivalenceClass)safetyEdge.successor(), (RoundRobinState)livenessEdge.successor(), state.evaluatedFixpoints, automata);
                BitSet acceptance = livenessEdge.colours().copyInto(new BitSet());
                acceptance.set(((GeneralizedBuchiAcceptance)livenessAutomaton.acceptance()).acceptanceSets(), ((EmersonLeiAcceptance)this.acceptance).acceptanceSets());
                return Edge.of(successor, acceptance);
            });
        }

        @Override
        public MutableAutomaton<SymmetricProductState, B> build() {
            return HashMapAutomaton.copyOf(new AbstractMemoizingAutomaton.EdgeTreeImplementation<SymmetricProductState, B>(this.factories.eqFactory.atomicPropositions(), this.factories.vsFactory, Set.copyOf(this.anchors), (GeneralizedBuchiAcceptance)this.acceptance){

                @Override
                public MtBdd<Edge<SymmetricProductState>> edgeTreeImpl(SymmetricProductState state) {
                    return AcceptingComponentBuilder.this.edgeTree(state);
                }
            });
        }
    }
}

