/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import owl.bdd.EquivalenceClassFactory;
import owl.ltl.Conjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.LtlLanguageExpressible;
import owl.ltl.SyntacticFragments;
import owl.translations.canonical.RoundRobinState;
import owl.translations.mastertheorem.SymmetricEvaluatedFixpoints;

public final class SymmetricProductState
implements LtlLanguageExpressible {
    public final EquivalenceClass safety;
    @Nullable
    public final RoundRobinState<EquivalenceClass> liveness;
    public final SymmetricEvaluatedFixpoints evaluatedFixpoints;
    public final SymmetricEvaluatedFixpoints.DeterministicAutomata automata;
    private final int hashCode;

    SymmetricProductState(EquivalenceClass safety, @Nullable RoundRobinState<EquivalenceClass> liveness, SymmetricEvaluatedFixpoints evaluatedFixpoints, SymmetricEvaluatedFixpoints.DeterministicAutomata automata) {
        this.liveness = liveness;
        this.evaluatedFixpoints = evaluatedFixpoints;
        this.safety = safety;
        this.automata = automata;
        this.hashCode = Objects.hash(liveness, evaluatedFixpoints, safety);
        assert (SyntacticFragments.isSafety(safety));
        assert (liveness == null || SyntacticFragments.isCoSafety(liveness.state()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SymmetricProductState)) {
            return false;
        }
        SymmetricProductState that = (SymmetricProductState)o;
        return this.hashCode == that.hashCode && this.safety.equals(that.safety) && Objects.equals(this.liveness, that.liveness) && this.evaluatedFixpoints.equals(that.evaluatedFixpoints);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public EquivalenceClass language() {
        EquivalenceClassFactory factory = this.safety.factory();
        return this.safety.and(factory.of(Conjunction.of(this.evaluatedFixpoints.infinitelyOften))).unfold();
    }

    public boolean isCoveredBy(SymmetricProductState that) {
        EquivalenceClass thatLiveness;
        if (!this.safety.implies(that.safety)) {
            return false;
        }
        EquivalenceClass thisLiveness = this.liveness == null ? this.safety.factory().of(true) : this.liveness.state();
        EquivalenceClass equivalenceClass = thatLiveness = that.liveness == null ? this.safety.factory().of(true) : that.liveness.state();
        if (!thisLiveness.implies(thatLiveness)) {
            return false;
        }
        if (!this.evaluatedFixpoints.almostAlways.containsAll(that.evaluatedFixpoints.almostAlways)) {
            return false;
        }
        return this.evaluatedFixpoints.infinitelyOften.containsAll(that.evaluatedFixpoints.infinitelyOften);
    }

    public String toString() {
        String[] pieces = new String[]{this.safety.isTrue() ? null : "GWR=" + this.safety, this.liveness == null ? null : "FUM=" + this.liveness};
        return this.evaluatedFixpoints + Arrays.stream(pieces).filter(Objects::nonNull).collect(Collectors.joining(", ", " [", "]"));
    }
}

