/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.mastertheorem;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.Formulas;
import owl.ltl.GOperator;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.translations.mastertheorem.AutoValue_Fixpoints;
import owl.translations.mastertheorem.Predicates;

@AutoValue
public abstract class Fixpoints
implements Comparable<Fixpoints> {
    public abstract Set<Formula.TemporalOperator> leastFixpoints();

    public abstract Set<Formula.TemporalOperator> greatestFixpoints();

    public static Fixpoints of(Collection<? extends Formula.TemporalOperator> leastFixpoints, Collection<? extends Formula.TemporalOperator> greatestFixpoints) {
        Set<Formula.TemporalOperator> leastFixpointsCopy = Set.copyOf(leastFixpoints);
        Set<Formula.TemporalOperator> greatestFixpointsCopy = Set.copyOf(greatestFixpoints);
        Preconditions.checkArgument((boolean)leastFixpointsCopy.stream().allMatch(Predicates.IS_LEAST_FIXPOINT));
        Preconditions.checkArgument((boolean)greatestFixpointsCopy.stream().allMatch(Predicates.IS_GREATEST_FIXPOINT));
        return new AutoValue_Fixpoints(leastFixpointsCopy, greatestFixpointsCopy);
    }

    public static Fixpoints of(Collection<? extends Formula.TemporalOperator> fixpoints) {
        HashSet<Formula.TemporalOperator> leastFixpoints = new HashSet<Formula.TemporalOperator>();
        HashSet<Formula.TemporalOperator> greatestFixpoints = new HashSet<Formula.TemporalOperator>();
        for (Formula.TemporalOperator temporalOperator : fixpoints) {
            if (Predicates.IS_LEAST_FIXPOINT.test(temporalOperator)) {
                leastFixpoints.add(temporalOperator);
                continue;
            }
            assert (Predicates.IS_GREATEST_FIXPOINT.test(temporalOperator));
            greatestFixpoints.add(temporalOperator);
        }
        return Fixpoints.of(Set.of((Formula.TemporalOperator[])leastFixpoints.toArray(Formula.TemporalOperator[]::new)), Set.of((Formula.TemporalOperator[])greatestFixpoints.toArray(Formula.TemporalOperator[]::new)));
    }

    public boolean allFixpointsPresent(Collection<? extends Formula.TemporalOperator> formulas) {
        HashSet<Formula.TemporalOperator> waitingFixpoints = new HashSet<Formula.TemporalOperator>(this.leastFixpoints());
        waitingFixpoints.addAll(this.greatestFixpoints());
        waitingFixpoints.removeAll(formulas);
        return waitingFixpoints.isEmpty();
    }

    @Override
    public int compareTo(Fixpoints that) {
        return Formulas.compare(this.fixpoints(), that.fixpoints());
    }

    public abstract boolean equals(Object var1);

    @Memoized
    public Set<Formula.TemporalOperator> fixpoints() {
        return Set.copyOf(Sets.union(this.leastFixpoints(), this.greatestFixpoints()));
    }

    @Memoized
    public abstract int hashCode();

    @Memoized
    public Fixpoints simplified() {
        HashSet fOperators = new HashSet();
        HashSet gOperators = new HashSet();
        this.leastFixpoints().forEach(x -> {
            if (x instanceof MOperator) {
                fOperators.add(new FOperator(((MOperator)x).leftOperand()));
            } else if (x instanceof UOperator) {
                fOperators.add(new FOperator(((UOperator)x).rightOperand()));
            } else {
                fOperators.add((FOperator)x);
            }
        });
        this.greatestFixpoints().forEach(x -> {
            if (x instanceof ROperator) {
                gOperators.add(new GOperator(((ROperator)x).rightOperand()));
            } else if (x instanceof WOperator) {
                gOperators.add(new GOperator(((WOperator)x).leftOperand()));
            } else {
                gOperators.add((GOperator)x);
            }
        });
        Fixpoints simplifiedFixpoints = Fixpoints.of(fOperators, gOperators);
        return this.equals(simplifiedFixpoints) ? this : simplifiedFixpoints;
    }
}

