/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nbadet;

import com.google.auto.value.AutoValue;
import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import owl.automaton.algorithm.SccDecomposition;
import owl.collections.BitSet2;
import owl.command.AutomatonConversionCommands;
import owl.translations.nbadet.AutoValue_NbaDetConfSets;

@AutoValue
public abstract class NbaDetConfSets {
    public abstract BitSet rsccStates();

    public abstract BitSet asccStates();

    public abstract List<BitSet> asccsStates();

    public abstract List<BitSet> dsccsStates();

    public abstract List<BitSet> msccsStates();

    public static <S> NbaDetConfSets of(AutomatonConversionCommands.Nba2DpaCommand args, SccDecomposition<? extends S> scci, BiMap<S, Integer> stateMap) {
        BitSet merged;
        HashSet<Integer> handled = new HashSet<Integer>();
        BitSet rejStatesBS = new BitSet();
        if (args.sepRej()) {
            Set rejStates = scci.rejectingSccs().stream().flatMap(i -> scci.sccs().get((int)i).stream()).collect(Collectors.toUnmodifiableSet());
            rejStatesBS = BitSet2.copyOf(rejStates, arg_0 -> stateMap.get(arg_0));
            handled.addAll(scci.rejectingSccs());
        }
        BitSet accStatesBS = new BitSet();
        ArrayList<BitSet> asccs = new ArrayList<BitSet>();
        if (args.sepAcc()) {
            List<Set> accSccs = scci.acceptingSccs().stream().map(i -> scci.sccs().get((int)i)).collect(Collectors.toUnmodifiableList());
            Set accStates = accSccs.stream().flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
            accStatesBS = BitSet2.copyOf(accStates, arg_0 -> stateMap.get(arg_0));
            accSccs.forEach(s -> asccs.add(BitSet2.copyOf(s, arg_0 -> stateMap.get(arg_0))));
            if (!args.sepAccCyc()) {
                merged = asccs.stream().reduce(BitSet2::union).orElse(new BitSet());
                asccs.clear();
                asccs.add(merged);
            }
            handled.addAll(scci.acceptingSccs());
        }
        ArrayList dsccs = new ArrayList();
        if (args.sepDet()) {
            List unhDetSccs = scci.deterministicSccs().stream().filter(i -> !handled.contains(i)).collect(Collectors.toUnmodifiableList());
            List<Set> expDetSccs = unhDetSccs.stream().map(i -> scci.sccs().get((int)i)).collect(Collectors.toUnmodifiableList());
            expDetSccs.forEach(s -> dsccs.add(BitSet2.copyOf(s, arg_0 -> stateMap.get(arg_0))));
            handled.addAll(unhDetSccs);
        }
        ArrayList<BitSet> msccs = new ArrayList<BitSet>();
        IntStream.range(0, scci.sccs().size()).filter(i -> !handled.contains(i)).forEach(i -> msccs.add(BitSet2.copyOf(scci.sccs().get(i), arg_0 -> stateMap.get(arg_0))));
        if (!args.sepMix()) {
            merged = msccs.stream().reduce(BitSet2::union).orElse(new BitSet());
            msccs.clear();
            if (!merged.isEmpty()) {
                msccs.add(merged);
            }
        }
        return new AutoValue_NbaDetConfSets(rejStatesBS, accStatesBS, List.copyOf(asccs), List.copyOf(dsccs), List.copyOf(msccs));
    }
}

