/*
 * Decompiled with CFR 0.152.
 */
package owl.util;

import com.google.auto.value.AutoValue;
import owl.util.AutoValue_OwlVersion_NameAndVersion;
import picocli.CommandLine;

public final class OwlVersion
implements CommandLine.IVersionProvider {
    private static final String NAME = "owl";
    private static final String VERSION = "21.0";

    private OwlVersion() {
    }

    @Override
    public String[] getVersion() throws Exception {
        NameAndVersion nameAndVersion = OwlVersion.getNameAndVersion();
        return new String[]{nameAndVersion.name() + " (version: " + nameAndVersion.version() + ")"};
    }

    public static NameAndVersion getNameAndVersion() {
        Package owlPackage = OwlVersion.class.getPackage();
        String mainName = owlPackage.getImplementationTitle();
        if (mainName == null) {
            mainName = NAME;
        } else if (!mainName.equals(NAME)) {
            throw new IllegalStateException("Conflicting main names.");
        }
        String version = owlPackage.getImplementationVersion();
        if (version == null) {
            version = VERSION;
        } else if (!version.equals(VERSION)) {
            throw new IllegalStateException("Conflicting versions.");
        }
        return NameAndVersion.of(mainName, version);
    }

    @AutoValue
    public static abstract class NameAndVersion {
        public abstract String name();

        public abstract String version();

        private static NameAndVersion of(String name, String version) {
            return new AutoValue_OwlVersion_NameAndVersion(name, version);
        }
    }
}

