/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileBreak;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Genealogy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWhile;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorAndStyle;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileFactoryDelegatorWhile
extends FtileFactoryDelegator {
    public FtileFactoryDelegatorWhile(FtileFactory factory) {
        super(factory);
    }

    @Override
    public Ftile createWhile(Swimlane swimlane, Ftile whileBlock, Display test, Display yes, Display out, LinkRendering afterEndwhile, HtmlColor color, Instruction specialOut) {
        HtmlColor borderColor = this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityDiamondBorder);
        HtmlColor backColor = color == null ? this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityDiamondBackground) : color;
        final Rainbow arrowColor = HtmlColorAndStyle.build(this.skinParam());
        ConditionStyle conditionStyle = this.skinParam().getConditionStyle();
        FontParam testParam = conditionStyle == ConditionStyle.INSIDE ? FontParam.ACTIVITY_DIAMOND : FontParam.ARROW;
        FontConfiguration fcTest = new FontConfiguration(this.skinParam(), testParam, null);
        LinkRendering endInlinkRendering = whileBlock.getOutLinkRendering();
        Rainbow endInlinkColor = endInlinkRendering == null || endInlinkRendering.getRainbow().size() == 0 ? arrowColor : endInlinkRendering.getRainbow();
        FontConfiguration fontArrow = new FontConfiguration(this.skinParam(), FontParam.ARROW, null);
        Ftile result = FtileWhile.create(swimlane, whileBlock, test, borderColor, backColor, arrowColor, yes, out, endInlinkColor, afterEndwhile, fontArrow, this.getFactory(), conditionStyle, fcTest, specialOut);
        List<WeldingPoint> weldingPoints = whileBlock.getWeldingPoints();
        if (weldingPoints.size() > 0) {
            final Genealogy genealogy = new Genealogy(result);
            for (WeldingPoint w : weldingPoints) {
                final FtileBreak ftileBreak = (FtileBreak)w;
                result = FtileUtils.addConnection(result, new Connection(){

                    @Override
                    public void drawU(UGraphic ug) {
                        UTranslate tr1 = genealogy.getTranslate(ftileBreak, ug.getStringBounder());
                        Snake snake = new Snake(this.getFtile1().arrowHorizontalAlignment(), arrowColor, Arrows.asToLeft());
                        snake.addPoint(tr1.getDx(), tr1.getDy());
                        snake.addPoint(12.0, tr1.getDy());
                        ug.draw(snake);
                    }

                    @Override
                    public Ftile getFtile1() {
                        return ftileBreak;
                    }

                    @Override
                    public Ftile getFtile2() {
                        return null;
                    }
                });
            }
        }
        return result;
    }
}

