/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.AbstractAtom;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.sprite.Sprite;

public class AtomSprite
extends AbstractAtom
implements Atom {
    private final Sprite sprite;
    private final double scale;
    private final Url url;
    private final HtmlColor color;

    @Override
    public List<Atom> splitInTwo(StringBounder stringBounder, double width) {
        return Arrays.asList(this);
    }

    public AtomSprite(HtmlColor newColor, double scale, FontConfiguration fontConfiguration, Sprite sprite, Url url) {
        this.scale = scale;
        this.sprite = sprite;
        this.url = url;
        this.color = newColor == null ? fontConfiguration.getColor() : newColor;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.sprite.asTextBlock(this.color, this.scale).calculateDimension(stringBounder);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.sprite.asTextBlock(this.color, this.scale).drawU(ug);
        if (this.url != null) {
            ug.closeAction();
        }
    }
}

