/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.dot.Neighborhood;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

public final class DotData
implements PortionShower {
    private final List<Link> links;
    private final Collection<ILeaf> leafs;
    private final UmlDiagramType umlDiagramType;
    private final ISkinParam skinParam;
    private final GroupHierarchy groupHierarchy;
    private final IGroup topParent;
    private final PortionShower portionShower;
    private final boolean isHideEmptyDescriptionForState;
    private final DotMode dotMode;
    private final String namespaceSeparator;
    private final Pragma pragma;
    private final ColorMapper colorMapper;
    private final EntityFactory entityFactory;

    public DotData(IGroup topParent, List<Link> links, Collection<ILeaf> leafs, UmlDiagramType umlDiagramType, ISkinParam skinParam, GroupHierarchy groupHierarchy, PortionShower portionShower, ColorMapper colorMapper, EntityFactory entityFactory, boolean isHideEmptyDescriptionForState, DotMode dotMode, String namespaceSeparator, Pragma pragma) {
        this.namespaceSeparator = namespaceSeparator;
        this.pragma = pragma;
        this.topParent = topParent;
        if (topParent == null) {
            throw new IllegalArgumentException();
        }
        this.dotMode = dotMode;
        this.isHideEmptyDescriptionForState = isHideEmptyDescriptionForState;
        this.colorMapper = colorMapper;
        this.links = links;
        this.leafs = leafs;
        this.umlDiagramType = umlDiagramType;
        this.skinParam = skinParam;
        this.groupHierarchy = groupHierarchy;
        this.portionShower = portionShower;
        this.entityFactory = entityFactory;
    }

    public DotData(IGroup topParent, List<Link> links, Collection<ILeaf> leafs, UmlDiagramType umlDiagramType, ISkinParam skinParam, GroupHierarchy groupHierarchy, ColorMapper colorMapper, EntityFactory entityFactory, boolean isHideEmptyDescriptionForState, DotMode dotMode, String namespaceSeparator, Pragma pragma) {
        this(topParent, links, leafs, umlDiagramType, skinParam, groupHierarchy, new PortionShower(){

            @Override
            public boolean showPortion(EntityPortion portion, IEntity entity) {
                return true;
            }
        }, colorMapper, entityFactory, isHideEmptyDescriptionForState, dotMode, namespaceSeparator, pragma);
    }

    public UmlDiagramType getUmlDiagramType() {
        return this.umlDiagramType;
    }

    public ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public GroupHierarchy getGroupHierarchy() {
        return this.groupHierarchy;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public Collection<ILeaf> getLeafs() {
        return this.leafs;
    }

    public final IGroup getTopParent() {
        return this.topParent;
    }

    public boolean isEmpty(IGroup g) {
        return this.groupHierarchy.isEmpty(g);
    }

    @Override
    public boolean showPortion(EntityPortion portion, IEntity entity) {
        return this.portionShower.showPortion(portion, entity);
    }

    public final ColorMapper getColorMapper() {
        return this.colorMapper;
    }

    public IGroup getRootGroup() {
        return this.entityFactory.getRootGroup();
    }

    public final boolean isHideEmptyDescriptionForState() {
        return this.isHideEmptyDescriptionForState;
    }

    public final DotMode getDotMode() {
        return this.dotMode;
    }

    public final String getNamespaceSeparator() {
        return this.namespaceSeparator;
    }

    public Pragma getPragma() {
        return this.pragma;
    }

    public void removeIrrelevantSametail() {
        HashMap<String, Integer> sametails = new HashMap<String, Integer>();
        for (Link link : this.links) {
            String sametail;
            if (link.getType().getDecor2() == LinkDecor.EXTENDS) {
                link.setSametail(link.getEntity1().getUid());
            }
            if ((sametail = link.getSametail()) == null) continue;
            Integer value = (Integer)sametails.get(sametail);
            sametails.put(sametail, value == null ? 1 : value + 1);
        }
        HashSet<String> toremove = new HashSet<String>();
        int limit = this.skinParam.groupInheritance();
        for (Map.Entry ent : sametails.entrySet()) {
            String key = (String)ent.getKey();
            if ((Integer)ent.getValue() < limit) {
                toremove.add(key);
                continue;
            }
            ArrayList<Link> some = new ArrayList<Link>();
            for (Link link : this.links) {
                if (!key.equals(link.getSametail())) continue;
                some.add(link);
            }
            ILeaf leaf = this.getLeaf(key);
            Neighborhood neighborhood = new Neighborhood(leaf, some, this.getLinksOfThisLeaf(leaf));
            leaf.setNeighborhood(neighborhood);
        }
        for (Link link : this.links) {
            String sametail = link.getSametail();
            if (sametail == null || !toremove.contains(sametail)) continue;
            link.setSametail(null);
        }
    }

    private List<Link> getLinksOfThisLeaf(ILeaf leaf) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.links) {
            if (!link.contains(leaf)) continue;
            result.add(link);
        }
        return result;
    }

    private ILeaf getLeaf(String key) {
        for (ILeaf entity : this.leafs) {
            if (!entity.getUid().equals(key)) continue;
            return entity;
        }
        return null;
    }
}

