/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UFont;

abstract class AbstractEntityImage {
    private final IEntity entity;
    private final HtmlColor red = HtmlColorUtils.MY_RED;
    private final HtmlColor yellow = HtmlColorUtils.MY_YELLOW;
    private final HtmlColor yellowNote = HtmlColorUtils.COL_FBFB77;
    private final UFont font14 = UFont.sansSerif(14);
    private final UFont font17 = UFont.courier(17).bold();
    private final HtmlColor green = HtmlColorUtils.COL_ADD1B2;
    private final HtmlColor violet = HtmlColorUtils.COL_B4A7E5;
    private final HtmlColor blue = HtmlColorUtils.COL_A9DCDF;
    private final HtmlColor rose = HtmlColorUtils.COL_EB937F;

    public AbstractEntityImage(IEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("entity null");
        }
        this.entity = entity;
    }

    public abstract Dimension2D getDimension(StringBounder var1);

    public abstract void draw(ColorMapper var1, Graphics2D var2);

    protected final IEntity getEntity() {
        return this.entity;
    }

    protected final HtmlColor getRed() {
        return this.red;
    }

    protected final HtmlColor getYellow() {
        return this.yellow;
    }

    protected final UFont getFont17() {
        return this.font17;
    }

    protected final UFont getFont14() {
        return this.font14;
    }

    protected final HtmlColor getGreen() {
        return this.green;
    }

    protected final HtmlColor getViolet() {
        return this.violet;
    }

    protected final HtmlColor getBlue() {
        return this.blue;
    }

    protected final HtmlColor getRose() {
        return this.rose;
    }

    protected final HtmlColor getYellowNote() {
        return this.yellowNote;
    }
}

