/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineInstrumented;
import net.sourceforge.plantuml.utils.StartUtils;

public class UncommentReadLine
extends ReadLineInstrumented
implements ReadLine {
    private static final Pattern2 unpause = MyPattern.cmpile("(?i)((?:\\W|\\<[^<>]*\\>)*)[@\\\\]unpause");
    private final ReadLine raw;
    private String headerToRemove;
    private boolean paused;

    public UncommentReadLine(ReadLine source) {
        this.raw = source;
    }

    @Override
    public String toString() {
        return "UncommentReadLine of " + this.raw;
    }

    @Override
    StringLocated readLineInst() throws IOException {
        Matcher2 m2;
        StringLocated result = this.raw.readLine();
        if (result == null) {
            return null;
        }
        String tmp = StartUtils.beforeStartUml(result.getString());
        if (tmp != null) {
            this.headerToRemove = tmp;
        }
        if (this.paused && (m2 = unpause.matcher(result.getString())).find()) {
            this.headerToRemove = m2.group(1);
        }
        if (this.headerToRemove != null && this.headerToRemove.startsWith(result.getString())) {
            return new StringLocated("", result.getLocation());
        }
        if (this.headerToRemove != null && result.getString().startsWith(this.headerToRemove)) {
            return result.sub(this.headerToRemove.length(), result.getString().length());
        }
        return result;
    }

    @Override
    void closeInst() throws IOException {
        this.raw.close();
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }
}

