/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc2;

import java.io.IOException;
import java.util.List;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.preproc.DefinesGet;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineList;
import net.sourceforge.plantuml.preproc2.PreprocessorDefineLearner;
import net.sourceforge.plantuml.preproc2.ReadFilter;
import net.sourceforge.plantuml.preproc2.ReadLineInsertable;

public class PreprocessorDefineApply
implements ReadFilter {
    private final DefinesGet defines;

    public PreprocessorDefineApply(DefinesGet defines) throws IOException {
        this.defines = defines;
    }

    @Override
    public ReadLine applyFilter(ReadLine source) {
        return new Inner(source);
    }

    class Inner
    extends ReadLineInsertable {
        final ReadLine source;

        Inner(ReadLine source) {
            this.source = source;
        }

        @Override
        void closeInternal() throws IOException {
            this.source.close();
        }

        @Override
        StringLocated readLineInternal() throws IOException {
            StringLocated s = this.source.readLine();
            if (s == null || s.getPreprocessorError() != null) {
                return s;
            }
            if (PreprocessorDefineLearner.isLearningLine(s)) {
                return s;
            }
            List<String> result = PreprocessorDefineApply.this.defines.get().applyDefines(s.getString());
            if (result.size() > 1) {
                this.insert(new ReadLineList(result, s.getLocation()));
                return this.readLine();
            }
            String tmp = result.get(0);
            return new StringLocated(tmp, s.getLocation(), s.getPreprocessorError());
        }
    }
}

