/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AParentFolder;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.preproc.DefinesGet;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc2.ReadFilter;
import net.sourceforge.plantuml.utils.StartUtils;

public class PreprocessorDefineLearner
implements ReadFilter {
    private static final String END_DEFINE_LONG = "!enddefinelong";
    private static final String ID = "[A-Za-z_][A-Za-z_0-9]*";
    private static final String ID_ARG = "\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?";
    private static final String ARG = "(?:\\(\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?(?:,\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?)*?\\))?";
    private static final Pattern2 defineShortPattern = MyPattern.cmpile("^[%s]*!define[%s]+([A-Za-z_][A-Za-z_0-9]*(?:\\(\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?(?:,\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?)*?\\))?)(?:[%s]+(.*))?$");
    private static final Pattern2 filenamePattern = MyPattern.cmpile("^[%s]*!filename[%s]+(.+)$");
    private static final Pattern2 undefPattern = MyPattern.cmpile("^[%s]*!undef[%s]+([A-Za-z_][A-Za-z_0-9]*)$");
    private static final Pattern2 definelongPattern = MyPattern.cmpile("^[%s]*!definelong[%s]+([A-Za-z_][A-Za-z_0-9]*(?:\\(\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?(?:,\\s*[A-Za-z_][A-Za-z_0-9]*\\s*(?:=\\s*(?:\"[^\"]*\"|'[^']*')\\s*)?)*?\\))?)");
    private static final Pattern2 enddefinelongPattern = MyPattern.cmpile("^[%s]*!enddefinelong[%s]*$");
    private final DefinesGet defines;
    private final AParentFolder currentDir;

    public PreprocessorDefineLearner(DefinesGet defines, AParentFolder currentDir) {
        this.defines = defines;
        this.currentDir = currentDir;
    }

    public static boolean isLearningLine(StringLocated s) {
        Matcher2 m = defineShortPattern.matcher(s.getString());
        if (m.find()) {
            return true;
        }
        m = definelongPattern.matcher(s.getString());
        if (m.find()) {
            return true;
        }
        m = undefPattern.matcher(s.getString());
        return m.find();
    }

    @Override
    public ReadLine applyFilter(final ReadLine source) {
        return new ReadLine(){

            @Override
            public void close() throws IOException {
                source.close();
            }

            @Override
            public StringLocated readLine() throws IOException {
                StringLocated s;
                while (true) {
                    if ((s = source.readLine()) == null || s.getPreprocessorError() != null) {
                        return s;
                    }
                    if (StartUtils.isArobaseStartDiagram(s.getString())) {
                        PreprocessorDefineLearner.this.defines.restoreState();
                        return s;
                    }
                    Matcher2 m = filenamePattern.matcher(s.getString());
                    if (m.find()) {
                        PreprocessorDefineLearner.this.manageFilename(m);
                        continue;
                    }
                    m = defineShortPattern.matcher(s.getString());
                    if (m.find()) {
                        PreprocessorDefineLearner.this.manageDefineShort(source, m, s.getString().trim().endsWith("()"));
                        continue;
                    }
                    m = definelongPattern.matcher(s.getString());
                    if (m.find()) {
                        PreprocessorDefineLearner.this.manageDefineLong(source, m, s.getString().trim().endsWith("()"));
                        continue;
                    }
                    m = undefPattern.matcher(s.getString());
                    if (!m.find()) break;
                    PreprocessorDefineLearner.this.manageUndef(m);
                }
                return s;
            }
        };
    }

    private void manageUndef(Matcher2 m) throws IOException {
        this.defines.get().undefine(m.group(1));
    }

    private void manageDefineLong(ReadLine source, Matcher2 m, boolean emptyParentheses) throws IOException {
        String group1 = m.group(1);
        ArrayList<String> def = new ArrayList<String>();
        StringLocated read;
        while ((read = source.readLine()) != null) {
            if (enddefinelongPattern.matcher(read.getString()).find()) {
                this.defines.get().define(group1, def, emptyParentheses, this.currentDir);
                return;
            }
            def.add(read.getString());
        }
        return;
    }

    private void manageFilename(Matcher2 m) {
        String group1 = m.group(1);
        this.defines.get().overrideFilename(group1);
    }

    private void manageDefineShort(ReadLine source, Matcher2 m, boolean emptyParentheses) throws IOException {
        String group1 = m.group(1);
        String group2 = m.group(2);
        if (group2 == null) {
            this.defines.get().define(group1, null, emptyParentheses, null);
        } else {
            List<String> strings = this.defines.get().applyDefines(group2);
            if (strings.size() > 1) {
                this.defines.get().define(group1, strings, emptyParentheses, null);
            } else {
                StringBuilder value = new StringBuilder(strings.get(0));
                while (StringUtils.endsWithBackslash(value.toString())) {
                    value.setLength(value.length() - 1);
                    StringLocated read = source.readLine();
                    value.append(read.getString());
                }
                ArrayList<String> li = new ArrayList<String>();
                li.add(value.toString());
                this.defines.get().define(group1, li, emptyParentheses, null);
            }
        }
    }
}

