/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.LoadPlanable;
import net.sourceforge.plantuml.project3.ResourceDraw;
import net.sourceforge.plantuml.project3.Subject;

public class Resource
implements Subject {
    private final String name;
    private ResourceDraw draw;
    private Set<Instant> closed = new TreeSet<Instant>();

    public Resource(String name, LoadPlanable loadPlanable) {
        this.name = name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        Resource other = (Resource)obj;
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public ResourceDraw getResourceDraw() {
        return this.draw;
    }

    public void setTaskDraw(ResourceDraw draw) {
        this.draw = draw;
    }

    public boolean isClosedAt(Instant instant) {
        return this.closed.contains(instant);
    }

    public void addCloseDay(Instant instant) {
        this.closed.add(instant);
    }
}

