/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Padder {
    private final double margin;
    private final double padding;
    private final HtmlColor backgroundColor;
    private final HtmlColor borderColor;
    private final double roundCorner;
    public static final Padder NONE = new Padder(0.0, 0.0, null, null, 0.0);

    public String toString() {
        return "" + this.margin + "/" + this.padding + "/" + this.borderColor + "/" + this.backgroundColor;
    }

    private Padder(double margin, double padding, HtmlColor backgroundColor, HtmlColor borderColor, double roundCorner) {
        this.margin = margin;
        this.padding = padding;
        this.borderColor = borderColor;
        this.backgroundColor = backgroundColor;
        this.roundCorner = roundCorner;
    }

    public Padder withMargin(double margin) {
        return new Padder(margin, this.padding, this.backgroundColor, this.borderColor, this.roundCorner);
    }

    public Padder withPadding(double padding) {
        return new Padder(this.margin, padding, this.backgroundColor, this.borderColor, this.roundCorner);
    }

    public Padder withBackgroundColor(HtmlColor backgroundColor) {
        return new Padder(this.margin, this.padding, backgroundColor, this.borderColor, this.roundCorner);
    }

    public Padder withBorderColor(HtmlColor borderColor) {
        return new Padder(this.margin, this.padding, this.backgroundColor, borderColor, this.roundCorner);
    }

    public Padder withRoundCorner(double roundCorner) {
        return new Padder(this.margin, this.padding, this.backgroundColor, this.borderColor, roundCorner);
    }

    public final double getMargin() {
        return this.margin;
    }

    public final double getPadding() {
        return this.padding;
    }

    public final HtmlColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public final HtmlColor getBorderColor() {
        return this.borderColor;
    }

    public TextBlock apply(final TextBlock orig) {
        if (this == NONE) {
            return orig;
        }
        return new AbstractTextBlock(){

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return Dimension2DDouble.delta(orig.calculateDimension(stringBounder), 2.0 * (Padder.this.margin + Padder.this.padding));
            }

            @Override
            public void drawU(UGraphic ug) {
                ug = ug.apply(new UTranslate(Padder.this.margin, Padder.this.margin));
                UGraphic ug2 = ug.apply(new UChangeBackColor(Padder.this.backgroundColor)).apply(new UChangeColor(Padder.this.borderColor));
                Dimension2D originalDim = orig.calculateDimension(ug.getStringBounder());
                URectangle rect = new URectangle(Dimension2DDouble.delta(originalDim, 2.0 * Padder.this.padding), Padder.this.roundCorner, Padder.this.roundCorner);
                ug2.draw(rect);
                orig.drawU(ug.apply(new UTranslate(Padder.this.padding, Padder.this.padding)));
            }
        };
    }
}

