/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseReference
extends AbstractTextualComponent {
    private final HtmlColor background;
    private final int cornersize = 10;
    private final TextBlock textHeader;
    private final double heightFooter = 5.0;
    private final double xMargin = 2.0;
    private final HorizontalAlignment position;
    private final SymbolContext symbolContext;

    public ComponentRoseReference(Style style, FontConfiguration font, SymbolContext symbolContext, FontConfiguration header, Display stringsToDisplay, HorizontalAlignment position, ISkinSimple spriteContainer, HtmlColor background) {
        super(style, LineBreakStrategy.NONE, stringsToDisplay.subList(1, stringsToDisplay.size()), font, HorizontalAlignment.LEFT, 4, 4, 4, spriteContainer, false, null, null);
        if (SkinParam.USE_STYLES()) {
            this.symbolContext = style.getSymbolContext(this.getIHtmlColorSet());
            this.background = style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet());
            this.position = style.value(PName.HorizontalAlignment).asHorizontalAlignment();
        } else {
            this.symbolContext = symbolContext;
            this.background = background;
            this.position = position;
        }
        this.textHeader = stringsToDisplay.subList(0, 1).create(header, HorizontalAlignment.LEFT, spriteContainer);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        double textPos;
        Dimension2D dimensionToUse = area.getDimensionToUse();
        StringBounder stringBounder = ug.getStringBounder();
        int textHeaderWidth = (int)this.getHeaderWidth(stringBounder);
        int textHeaderHeight = (int)this.getHeaderHeight(stringBounder);
        URectangle rect = new URectangle(dimensionToUse.getWidth() - 4.0 - this.symbolContext.getDeltaShadow(), dimensionToUse.getHeight() - 5.0);
        rect.setDeltaShadow(this.symbolContext.getDeltaShadow());
        ug = this.symbolContext.withBackColor(this.background).apply(ug);
        ug.apply(new UTranslate(2.0, 0.0)).draw(rect);
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        polygon.addPoint(textHeaderWidth, 0.0);
        polygon.addPoint(textHeaderWidth, textHeaderHeight - 10);
        polygon.addPoint(textHeaderWidth - 10, textHeaderHeight);
        polygon.addPoint(0.0, textHeaderHeight);
        polygon.addPoint(0.0, 0.0);
        ug = this.symbolContext.apply(ug);
        ug.apply(new UTranslate(2.0, 0.0)).draw(polygon);
        ug = ug.apply(new UStroke());
        this.textHeader.drawU(ug.apply(new UTranslate(15.0, 2.0)));
        if (this.position == HorizontalAlignment.CENTER) {
            double textWidth = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            textPos = (dimensionToUse.getWidth() - textWidth) / 2.0;
        } else if (this.position == HorizontalAlignment.RIGHT) {
            double textWidth = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            textPos = dimensionToUse.getWidth() - textWidth - (double)this.getMarginX2() - 2.0;
        } else {
            textPos = (double)this.getMarginX1() + 2.0;
        }
        this.getTextBlock().drawU(ug.apply(new UTranslate(textPos, this.getMarginY() + textHeaderHeight)));
    }

    private double getHeaderHeight(StringBounder stringBounder) {
        Dimension2D headerDim = this.textHeader.calculateDimension(stringBounder);
        return headerDim.getHeight() + 2.0;
    }

    private double getHeaderWidth(StringBounder stringBounder) {
        Dimension2D headerDim = this.textHeader.calculateDimension(stringBounder);
        return headerDim.getWidth() + 30.0 + 15.0;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + this.getHeaderHeight(stringBounder) + 5.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return Math.max(this.getTextWidth(stringBounder), this.getHeaderWidth(stringBounder)) + 4.0 + this.symbolContext.getDeltaShadow();
    }
}

