/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.expression;

import net.sourceforge.plantuml.tim.expression.TokenOperator;
import net.sourceforge.plantuml.tim.expression.TokenType;

public class Token {
    private final String surface;
    private final TokenType tokenType;

    public String toString() {
        return (Object)((Object)this.tokenType) + "{" + this.surface + "}";
    }

    public Token(char surface, TokenType tokenType) {
        this("" + surface, tokenType);
    }

    public Token(String surface, TokenType tokenType) {
        this.surface = surface;
        this.tokenType = tokenType;
    }

    public TokenOperator getTokenOperator() {
        if (this.tokenType != TokenType.OPERATOR) {
            throw new IllegalStateException();
        }
        char ch2 = this.surface.length() > 1 ? this.surface.charAt(1) : (char)'\u0000';
        return TokenOperator.getTokenOperator(this.surface.charAt(0), ch2);
    }

    public final String getSurface() {
        return this.surface;
    }

    public final TokenType getTokenType() {
        return this.tokenType;
    }

    public Token muteToFunction() {
        if (this.tokenType != TokenType.PLAIN_TEXT) {
            throw new IllegalStateException();
        }
        return new Token(this.surface, TokenType.FUNCTION_NAME);
    }
}

